/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;

public class ParticleUtils {
    public static void spawnRecyclerParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.1;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.8f, 0.3f), 0.6f), x, y + 0.05, z, 3, 0.08, 0.01, 0.08, 0.001);
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 1, 0.05, 0.01, 0.05, 0.002);
        }
        if (random.m_188501_() < 0.3f) {
            SimpleParticleType drop = random.m_188499_() ? ParticleTypes.f_123800_ : ParticleTypes.f_123803_;
            server.m_8767_((ParticleOptions)drop, x, y - 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y + 0.1, z, 1, 0.01, 0.01, 0.01, 0.001);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y, z, 1, 0.02, 0.01, 0.02, 0.001);
        }
    }

    public static void spawnFallingLeavesParticles(Level level, BlockPos pos, Block leavesBlock) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        RandomSource random = level.m_213780_();
        double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5);
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5);
        double dx = (random.m_188500_() - 0.5) * 0.02;
        double dy = -0.03 - random.m_188500_() * 0.01;
        double dz = (random.m_188500_() - 0.5) * 0.02;
        BlockState state = leavesBlock.m_49966_();
        BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, state);
        server.m_8767_((ParticleOptions)particle, x, y, z, 1, dx, dy, dz, 0.0);
    }

    public static void spawnCompressorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 3, 0.1, 0.02, 0.1, 0.003);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y + 0.05, z, 2, 0.02, 0.01, 0.02, 0.01);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustColorTransitionOptions(new Vector3f(0.4f, 0.6f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), 0.8f), x, y + 0.1, z, 2, 0.03, 0.01, 0.03, 0.001);
        }
    }

    public static void showFlames(ServerLevel level, BlockPos pos, Direction facing) {
        if (level.f_46441_.m_188503_(8) == 0) {
            double x = (double)pos.m_123341_() + ((double)facing.m_122429_() * 1.04 + 1.0) / 2.0;
            double y = (double)pos.m_123342_() + (double)level.f_46441_.m_188501_() * 0.375;
            double z = (double)pos.m_123343_() + ((double)facing.m_122431_() * 1.04 + 1.0) / 2.0;
            if (facing.m_122434_() == Direction.Axis.X) {
                z += (double)level.f_46441_.m_188501_() * 0.625 - 0.3125;
            } else {
                x += (double)level.f_46441_.m_188501_() * 0.625 - 0.3125;
            }
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnGearParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        Vector3f metalColor = new Vector3f(0.6f, 0.6f, 0.6f);
        if (random.m_188501_() < 0.7f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(metalColor, 0.6f), x, y + 0.05, z, 2, 0.02, 0.01, 0.02, 0.001);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.1, z, 2, 0.02, 0.01, 0.02, 0.01);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y + 0.15, z, 1, 0.01, 0.01, 0.01, 0.002);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.05, z, 1, 0.03, 0.01, 0.03, 0.002);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.02, 0.0, 0.02, 0.005);
        }
    }

    public static void spawnRollingMillParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.05;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 2, 0.02, 0.01, 0.02, 0.002);
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y + 0.05, z, 1, 0.01, 0.0, 0.01, 0.002);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.02, z, 1, 0.02, 0.01, 0.02, 0.002);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 2, 0.04, 0.01, 0.04, 0.002);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y + 0.05, z, 1, 0.01, 0.01, 0.01, 0.001);
        }
    }

    public static void spawnScrapCollectorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y, z, 2, 0.04, 0.01, 0.04, 0.001);
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.1, z, 1, 0.02, 0.01, 0.02, 0.001);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123745_, x, y + 0.05, z, 1, 0.01, 0.0, 0.01, 0.001);
        }
        if (random.m_188501_() < 0.5f) {
            Vector3f color = random.m_188499_() ? new Vector3f(0.25f, 0.2f, 0.15f) : new Vector3f(0.2f, 0.4f, 0.2f);
            server.m_8767_((ParticleOptions)new DustParticleOptions(color, 0.9f), x, y, z, 2, 0.02, 0.01, 0.02, 0.001);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y + 0.1, z, 1, 0.01, 0.01, 0.01, 0.002);
        }
    }

    public static void spawnFarmParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 2, 0.05, 0.01, 0.05, 0.001);
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_123769_, x, y - 0.1, z, 1, 0.02, 0.01, 0.02, 0.001);
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123803_, x, y - 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.4f, 0.7f, 0.2f), 0.9f), x, y, z, 2, 0.02, 0.01, 0.02, 0.001);
        }
    }

    public static void spawnCentrifugeParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 2, 0.03, 0.01, 0.03, 0.002);
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y + 0.1, z, 1, 0.01, 0.0, 0.01, 0.002);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 1, 0.02, 0.01, 0.02, 0.002);
        }
        server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.3f, 0.3f), 1.0f), x, y + 0.05, z, 2, 0.03, 0.01, 0.03, 0.002);
    }

    public static void spawnOreWashingParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_123769_, x, y, z, 2, 0.04, 0.01, 0.04, 0.001);
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123803_, x, y - 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.25f, 0.2f), 0.9f), x, y, z, 2, 0.02, 0.01, 0.02, 0.001);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.2, z, 1, 0.03, 0.01, 0.03, 0.001);
        }
    }

    public static void spawnExtruderParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.1;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.02, 0.01, 0.02, 0.001);
        }
        SimpleParticleType sticky = random.m_188499_() ? ParticleTypes.f_123800_ : ParticleTypes.f_123779_;
        server.m_8767_((ParticleOptions)sticky, x, y - 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
        server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.7f, 0.1f), 0.8f), x, y, z, 2, 0.01, 0.01, 0.01, 0.001);
    }

    public static void spawnExtractorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.05;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.9f, 0.3f), 0.7f), x, y, z, 3, 0.04, 0.01, 0.04, 0.002);
        if (random.m_188501_() < 0.4f) {
            SimpleParticleType drip = random.m_188499_() ? ParticleTypes.f_123779_ : ParticleTypes.f_123803_;
            server.m_8767_((ParticleOptions)drip, x, y - 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y + 0.15, z, 1, 0.01, 0.01, 0.01, 0.001);
        }
    }

    public static void spawnCutterParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.05;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 2, 0.05, 0.01, 0.05, 0.01);
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.4f, 0.4f, 0.4f), 0.9f), x, y + 0.1, z, 2, 0.02, 0.01, 0.02, 0.002);
        }
        if (random.m_188501_() < 0.25f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.03, 0.01, 0.03, 0.001);
        }
    }

    public static void spawnMaceratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.05;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y, z, 4, 0.1, 0.01, 0.1, 0.002);
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.05, z, 2, 0.02, 0.01, 0.02, 0.01);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.2f, 0.1f), 0.8f), x, y, z, 2, 0.03, 0.01, 0.03, 0.002);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.05, 0.01, 0.05, 0.001);
        }
    }

    public static void spawnMineralSeparatorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.1;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y, z, 5, 0.1, 0.01, 0.1, 0.002);
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.9f, 0.6f, 0.2f), 0.6f), x, y + 0.1, z, 2, 0.03, 0.01, 0.03, 0.001);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.05, z, 1, 0.02, 0.01, 0.02, 0.01);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y + 0.1, z, 1, 0.01, 0.01, 0.01, 0.001);
        }
    }

    public static void spawnMicrochipAssemblerParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.05;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 4, 0.04, 0.01, 0.04, 0.01);
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y + 0.1, z, 1, 0.01, 0.01, 0.01, 0.001);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.6f, 1.0f), 0.5f), x, y + 0.05, z, 2, 0.02, 0.01, 0.02, 0.001);
        }
        if (random.m_188501_() < 0.15f) {
            server.m_8767_((ParticleOptions)new DustColorTransitionOptions(new Vector3f(0.1f, 0.6f, 1.0f), new Vector3f(0.2f, 0.9f, 1.0f), 1.0f), x, y, z, 2, 0.01, 0.01, 0.01, 0.001);
        }
    }

    public static void spawnAlloySmelterParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.05;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 2, 0.08, 0.01, 0.08, 0.005);
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.1, z, 3, 0.05, 0.02, 0.05, 0.02);
        }
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.15, z, 1, 0.04, 0.01, 0.04, 0.002);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123800_, x, y - 0.2, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.4f, 0.0f), 1.0f), x, y + 0.05, z, 2, 0.05, 0.01, 0.05, 0.002);
        }
    }

    public static void spawnDieselGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.2;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.8f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 3, 0.15, 0.05, 0.15, 0.01);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.05f, 0.05f, 0.05f), 0.9f), x, y, z, 2, 0.02, 0.01, 0.02, 0.005);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123800_, x + random.m_188500_() * 0.3 - 0.15, y - 0.3, z + random.m_188500_() * 0.3 - 0.15, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.1, z, 1, 0.02, 0.01, 0.02, 0.01);
        }
        if (random.m_188501_() < 0.15f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y + 0.05, z, 1, 0.05, 0.02, 0.05, 0.001);
            server.m_8767_((ParticleOptions)ParticleTypes.f_175834_, x, y + 0.05, z, 1, 0.01, 0.01, 0.01, 0.005);
        }
    }

    public static void spawnGasolineGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.1;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 2, 0.05, 0.05, 0.05, 0.01);
        server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.6f, 0.2f), 0.5f), x, y + 0.1, z, 2, 0.05, 0.02, 0.05, 0.01);
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.15, z, 1, 0.02, 0.02, 0.02, 0.01);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y + 0.05, z, 1, 0.01, 0.01, 0.01, 0.01);
        }
    }

    public static void spawnFusionCoreParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.6f, 1.0f), 1.0f), x, y, z, 6, 0.2, 0.2, 0.2, 0.02);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 5, 0.3, 0.3, 0.3, 0.1);
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y + 0.2, z, 2, 0.1, 0.1, 0.1, 0.05);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1, 0.2, 0.2, 0.2, 0.01);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustColorTransitionOptions(new Vector3f(0.0f, 0.8f, 1.0f), new Vector3f(0.1f, 0.3f, 0.8f), 1.0f), x, y + 0.1, z, 4, 0.2, 0.1, 0.2, 0.01);
        }
    }

    public static void spawnRadiationParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.1f, 0.8f, 0.1f), 1.0f), x, y, z, 4, 0.2, 0.2, 0.2, 0.01);
        server.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y + 0.3, z, 2, 0.2, 0.2, 0.2, 0.1);
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123778_, x, y, z, 1, 0.05, 0.05, 0.05, 0.01);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.2, z, 1, 0.1, 0.1, 0.1, 0.02);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y + 0.5, z, 1, 0.05, 0.1, 0.05, 0.01);
        }
    }

    public static void spawnLavaGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.8f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 2, 0.1, 0.0, 0.1, 0.001);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 1, 0.03, 0.0, 0.03, 0.01);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.1, z, 1, 0.05, 0.01, 0.05, 0.002);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123783_, x, y + 0.2, z, 1, 0.02, 0.01, 0.02, 0.002);
        }
    }

    public static void spawnStoneGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.7f) {
            server.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50069_.m_49966_()), x, y, z, 2, 0.05, 0.0, 0.05, 0.1);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.6f, 0.6f), 0.5f), x, y, z, 1, 0.02, 0.01, 0.02, 0.001);
        }
    }

    public static void spawnFermenterParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + random.m_188500_();
        double y = (double)pos.m_123342_() + 0.5 + random.m_188500_() / 2.0;
        double z = (double)pos.m_123343_() + random.m_188500_();
        if (random.m_188501_() < 0.7f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 2, 0.05, 0.0, 0.05, 0.01);
        }
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123779_, x, y - 0.1, z, 1, 0.0, 0.0, 0.0, 0.001);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.8f, 0.9f, 0.1f), 0.7f), x, y, z, 2, 0.02, 0.01, 0.02, 0.001);
        }
    }

    public static void spawnApiaryParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + random.m_188500_();
        double y = (double)pos.m_123342_() + 0.5 + random.m_188500_() / 2.0;
        double z = (double)pos.m_123343_() + random.m_188500_();
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 2, 0.04, 0.01, 0.04, 0.001);
        }
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123779_, x, y - 0.1, z, 1, 0.0, 0.0, 0.0, 0.001);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.85f, 0.1f), 0.8f), x, y + 0.05, z, 2, 0.01, 0.01, 0.01, 0.001);
        }
    }

    public static void spawnWitherFabricatorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.1;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 2, 0.05, 0.0, 0.05, 0.002);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 1, 0.03, 0.01, 0.03, 0.001);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123789_, x, y + 0.1, z, 1, 0.05, 0.05, 0.05, 0.0);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.0f, 0.2f), 0.7f), x, y, z, 1, 0.02, 0.01, 0.02, 0.002);
        }
    }

    public static void spawnMagneticCatcherParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 2, 0.1, 0.0, 0.1, 0.001);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y + 0.1, z, 1, 0.03, 0.01, 0.03, 0.01);
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.3f, 0.6f, 1.0f), 0.7f), x, y + 0.2, z, 1, 0.01, 0.01, 0.01, 0.001);
        }
    }

    public static void spawnMagneticGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.1;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 2, 0.03, 0.01, 0.03, 0.01);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.9f, 0.9f), 0.5f), x, y, z, 1, 0.02, 0.01, 0.02, 0.001);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y + 0.15, z, 1, 0.05, 0.01, 0.05, 0.001);
        }
    }

    public static void spawnFishingMachineParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.2;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.7f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 2, 0.1, 0.0, 0.1, 0.01);
        }
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123769_, x, y, z, 1, 0.03, 0.0, 0.03, 0.02);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123816_, x, y + 0.2, z, 1, 0.01, 0.01, 0.01, 0.001);
        }
    }

    public static void spawnHydrogenGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 3, 0.05, 0.02, 0.05, 0.001);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 1, 0.01, 0.01, 0.01, 5.0E-4);
        }
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.6f, 0.9f, 1.0f), 1.2f), x, y + 0.1, z, 2, 0.03, 0.01, 0.03, 8.0E-4);
        }
    }

    public static void spawnObsidianGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 2, 0.03, 0.01, 0.03, 5.0E-4);
        }
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.1, z, 2, 0.05, 0.01, 0.05, 8.0E-4);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123800_, x, y - 0.1, z, 1, 0.0, 0.0, 0.0, 0.001);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.2, z, 1, 0.04, 0.01, 0.04, 0.001);
        }
    }

    public static void spawnHeliumGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.1;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 2, 0.01, 0.01, 0.01, 5.0E-4);
        }
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.7f, 0.9f, 1.0f), 0.8f), x, y, z, 3, 0.02, 0.01, 0.02, 4.0E-4);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1, 0.01, 0.01, 0.01, 5.0E-4);
        }
        if (random.m_188501_() < 0.1f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.1, z, 1, 0.03, 0.01, 0.03, 3.0E-4);
        }
    }

    public static void spawnPlasticParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123779_, x, y - 0.1, z, 1, 0.0, 0.0, 0.0, 0.001);
        }
        if (random.m_188501_() < 0.5f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.1, z, 2, 0.04, 0.01, 0.04, 0.001);
        }
        if (random.m_188501_() < 0.4f) {
            Vector3f color = switch (random.m_188503_(3)) {
                case 0 -> new Vector3f(1.0f, 0.9f, 0.5f);
                case 1 -> new Vector3f(0.9f, 0.8f, 0.3f);
                default -> new Vector3f(0.7f, 1.0f, 0.7f);
            };
            server.m_8767_((ParticleOptions)new DustParticleOptions(color, 0.7f), x, y, z, 2, 0.01, 0.01, 0.01, 0.001);
        }
    }

    public static void spawnElectrolyzerParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.1;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x, y, z, 2, 0.03, 0.01, 0.03, 0.001);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123772_, x, y - 0.05, z, 1, 0.01, 0.01, 0.01, 5.0E-4);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 1.0f, 0.9f), 0.8f), x, y + 0.05, z, 2, 0.02, 0.01, 0.02, 6.0E-4);
        }
        if (random.m_188501_() < 0.2f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 1, 0.02, 0.01, 0.02, 8.0E-4);
        }
    }

    public static void spawnWaterGeneratorParticles(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.05;
        double z = (double)pos.m_123343_() + 0.5;
        if (random.m_188501_() < 0.6f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 2, 0.01, 0.0, 0.01, 0.001);
        }
        if (random.m_188501_() < 0.4f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y - 0.1, z, 2, 0.02, 0.01, 0.02, 0.005);
        }
        if (random.m_188501_() < 0.3f) {
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.05, z, 1, 0.03, 0.01, 0.03, 0.002);
        }
    }
}

