/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.pollution.radiation.EnumCoefficient;
import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import com.denfop.api.pollution.radiation.Radiation;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityRadiationPurifier;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuRadiationPurifier;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ScreenRadiationPurifier<T extends ContainerMenuRadiationPurifier>
extends ScreenMain<ContainerMenuRadiationPurifier> {
    public ScreenRadiationPurifier(ContainerMenuRadiationPurifier guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        this.addComponent(new ScreenWidget(this, 8, 62, EnumTypeComponent.ENERGY, new WidgetDefault<Energy>(((BlockEntityRadiationPurifier)((ContainerMenuRadiationPurifier)this.container).base).energy)));
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        if (((BlockEntityRadiationPurifier)((ContainerMenuRadiationPurifier)this.container).base).radiation != null) {
            new TooltipWidget(this, 13, 11, 28, 10).withTooltip(Localization.translate("radiation.dose") + Math.max(1, (int)((BlockEntityRadiationPurifier)((ContainerMenuRadiationPurifier)this.container).base).radiation.getRadiation()) + " " + ModUtils.getUnit(((BlockEntityRadiationPurifier)((ContainerMenuRadiationPurifier)this.container).base).radiation.getCoef()) + "Sv").drawForeground(poseStack, par1, par2);
        } else {
            new TooltipWidget(this, 13, 11, 28, 10).withTooltip(Localization.translate("radiation.dose") + Math.max(0.5, 0.0) + " " + ModUtils.getUnit(EnumCoefficient.NANO) + "Sv").drawForeground(poseStack, par1, par2);
        }
    }

    @Override
    public void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.radiationpurifier.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 4; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.radiationpurifier.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        ScreenRadiationPurifier.bindTexture(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft + 3, this.guiTop + 3, 0, 0, 10, 10);
        ScreenRadiationPurifier.bindTexture(this.getTexture());
        this.bindTexture();
        if (((BlockEntityRadiationPurifier)((ContainerMenuRadiationPurifier)this.container).base).radiation == null) {
            this.drawTexturedRect(poseStack, 41.0, 12.0, 1.0, 3.0, 180.0, 19.0);
        } else {
            Radiation radiation = ((BlockEntityRadiationPurifier)((ContainerMenuRadiationPurifier)this.container).base).radiation;
            if (radiation.getLevel() == EnumLevelRadiation.LOW) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 41.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.DEFAULT) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 35.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.MEDIUM) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 29.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.HIGH) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 23.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            } else if (radiation.getLevel() == EnumLevelRadiation.VERY_HIGH) {
                double translate = 6.0 * radiation.getRadiation() / 1000.0;
                this.drawTexturedRect(poseStack, 17.0 - translate, 12.0, 1.0, 3.0, 180.0, 19.0);
            }
        }
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guipurifier.png");
    }
}

