/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.sound.AudioFixer;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.upgrades.UpgradeRegistry;
import com.denfop.api.widget.EmptyWidget;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityMultiMatter;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.containermenu.ContainerMenuMultiMatter;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;

@OnlyIn(value=Dist.CLIENT)
public class ScreenMultiMatter<T extends ContainerMenuMultiMatter>
extends ScreenMain<ContainerMenuMultiMatter> {
    public final ContainerMenuMultiMatter container;
    public final String progressLabel;
    public final String amplifierLabel;

    public ScreenMultiMatter(ContainerMenuMultiMatter container1) {
        super(container1, ((BlockEntityMultiMatter)container1.base).getStyle());
        this.container = container1;
        this.progressLabel = Localization.translate("Matter.gui.info.progress");
        this.amplifierLabel = Localization.translate("Matter.gui.info.amplifier");
        this.addComponent(new ScreenWidget(this, 4, 15, EnumTypeComponent.SOUND_BUTTON, new WidgetDefault<ComponentSoundButton>(new ComponentSoundButton((BlockEntityBase)((Object)this.container.base), 10, (AudioFixer)((Object)this.container.base)))));
        this.componentList.add(new ScreenWidget(this, 117, 41, EnumTypeComponent.FLUID_PART, new WidgetDefault<EmptyWidget>(new EmptyWidget())));
        this.componentList.add(new ScreenWidget(this, 45, 60, EnumTypeComponent.WORK_BUTTON, new WidgetDefault<1>(new ComponentButton((BlockEntityBase)((Object)this.container.base), 0, ""){

            @Override
            public String getText() {
                return ((BlockEntityMultiMatter)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((BlockEntityMultiMatter)this.getEntityBlock()).work;
            }
        })));
    }

    private static List<ItemStack> getCompatibleUpgrades(IUpgradableBlock block) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Set<UpgradableProperty> properties = block.getUpgradableProperties();
        for (ItemStack stack : UpgradeRegistry.getUpgrades()) {
            IUpgradeItem item = (IUpgradeItem)stack.m_41720_();
            if (!item.isSuitableFor(stack, properties)) continue;
            ret.add(stack);
        }
        return ret;
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.f_96543_ - this.getXSize()) / 2;
        int yMin = (this.f_96544_ - this.getYSize()) / 2;
        int x = i - xMin;
        int y = j - yMin;
    }

    @Override
    public void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.generic.text.upgrade"));
            for (ItemStack stack : ScreenMultiMatter.getCompatibleUpgrades((IUpgradableBlock)((Object)this.container.base))) {
                text.add(stack.m_41611_().getString());
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        TankWidget.createNormal(this, 96, 22, (IFluidTank)((BlockEntityMultiMatter)this.container.base).fluidTank).drawForeground(poseStack, par1, par2);
        this.draw(poseStack, this.progressLabel, 8, 29, 0x404040);
        this.draw(poseStack, ((BlockEntityMultiMatter)this.container.base).getProgressAsString(), 18, 39, 0x404040);
        if (((BlockEntityMultiMatter)this.container.base).scrap > 0) {
            this.draw(poseStack, this.amplifierLabel, 8, 49, 0x404040);
            this.draw(poseStack, "" + ((BlockEntityMultiMatter)this.container.base).scrap, 8, 59, 0x404040);
        }
        this.drawForeground(poseStack, par1, par2);
    }

    @Override
    protected void m_7286_(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        TankWidget.createNormal(this, 96, 22, (IFluidTank)((BlockEntityMultiMatter)this.container.base).fluidTank).drawBackground(poseStack, this.guiLeft(), this.guiTop());
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft(), this.guiTop(), 0, 0, this.getXSize(), this.getYSize());
        String name = Localization.translate(((BlockEntityMultiMatter)this.container.base).getName());
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        int centerX = this.guiLeft() + this.getXSize() / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop() + 6) / scale);
        this.draw(poseStack, name, textX, textY, 0x404040);
        pose.m_85849_();
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/guimachine.png");
    }
}

