/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.Star;
import com.denfop.recipe.universalrecipe.PlanetSerializer;
import com.denfop.recipe.universalrecipe.StarRecipe;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class StarSerializer
implements RecipeSerializer<StarRecipe> {
    public static final StarSerializer INSTANCE = new StarSerializer();

    public StarRecipe fromJson(ResourceLocation id, JsonObject json) {
        String name = json.get("name").getAsString();
        String systemStr = json.get("system").getAsString().toLowerCase();
        String textureStr = json.get("texture").getAsString();
        int angle = json.get("angle").getAsInt();
        double size = json.get("size").getAsDouble();
        ResourceLocation texture = ResourceLocation.m_135820_((String)(textureStr + ".png"));
        if (!PlanetSerializer.stringList.contains("star_" + name)) {
            SpaceInit.regStar.add(() -> new Star(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr)), texture, angle, size));
            PlanetSerializer.stringList.add("star_" + name);
        }
        return new StarRecipe(id, name, systemStr, textureStr, angle, size);
    }

    public StarRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        String systemName = buf.m_130277_();
        String texturePath = buf.m_130277_();
        int angle = buf.m_130242_();
        double size = buf.readDouble();
        ResourceLocation texture = ResourceLocation.m_135820_((String)(texturePath + ".png"));
        if (!PlanetSerializer.stringList.contains("star_" + name)) {
            SpaceInit.regStar.add(() -> new Star(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemName.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemName)), texture, angle, size));
            PlanetSerializer.stringList.add("star_" + name);
        }
        return new StarRecipe(id, name, systemName, texturePath, angle, size);
    }

    public void toNetwork(FriendlyByteBuf buf, StarRecipe recipe) {
        buf.m_130070_(recipe.name);
        buf.m_130070_(recipe.systemName);
        buf.m_130070_(recipe.texturePath);
        buf.m_130130_(recipe.angle.intValue());
        buf.writeDouble(recipe.size.doubleValue());
    }
}

