/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.IURecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class IURecipeSerializer
implements RecipeSerializer<IURecipe> {
    public static final IURecipeSerializer INSTANCE = new IURecipeSerializer();

    public IURecipe fromJson(ResourceLocation id, JsonObject json) {
        String recipeType = GsonHelper.m_13906_((JsonObject)json, (String)"recipe_type");
        boolean isFluidRecipe = GsonHelper.m_13855_((JsonObject)json, (String)"isFluidRecipe", (boolean)false);
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        if (GsonHelper.m_13900_((JsonObject)json, (String)"inputs")) {
            JsonArray inArray = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
            block18: for (JsonElement el : inArray) {
                Iterator obj = el.getAsJsonObject();
                String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
                String itemId = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
                int n = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
                switch (type) {
                    case "item": {
                        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), n);
                        inputs.add(new InputItemStack(stack));
                        continue block18;
                    }
                    case "fluid": {
                        FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(itemId)), n);
                        fluidStacks.add(fluidStack);
                        continue block18;
                    }
                    case "tag": {
                        inputs.add(new InputOreDict(itemId, n));
                        continue block18;
                    }
                }
                throw new IllegalArgumentException("Unknown input type: " + type);
            }
        }
        ArrayList<InputItemStack> outputs = new ArrayList<InputItemStack>();
        ArrayList<FluidStack> outputsFluid = new ArrayList<FluidStack>();
        JsonArray outArr = GsonHelper.m_13933_((JsonObject)json, (String)"outputs");
        block19: for (JsonElement el : outArr) {
            JsonObject obj = el.getAsJsonObject();
            String string = GsonHelper.m_13906_((JsonObject)obj, (String)"id");
            String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
            int amount = GsonHelper.m_13824_((JsonObject)obj, (String)"amount", (int)1);
            switch (type) {
                case "item": {
                    ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string)), amount);
                    outputs.add(new InputItemStack(stack));
                    continue block19;
                }
                case "fluid": {
                    FluidStack fluidStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(string)), amount);
                    outputsFluid.add(fluidStack);
                    continue block19;
                }
            }
            throw new IllegalArgumentException("Unknown input type: " + type);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (json.has("params")) {
            JsonObject pJson = json.getAsJsonObject("params");
            for (String string : pJson.keySet()) {
                JsonElement val = pJson.get(string);
                if (!val.isJsonPrimitive()) continue;
                if (val.getAsJsonPrimitive().isBoolean()) {
                    params.put(string, val.getAsBoolean());
                    continue;
                }
                if (val.getAsJsonPrimitive().isNumber()) {
                    params.put(string, val.getAsNumber());
                    continue;
                }
                params.put(string, val.getAsString());
            }
        }
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry entry : params.entrySet()) {
            if (entry.getValue() instanceof Boolean) {
                compoundTag.m_128379_((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
            }
            if (!(entry.getValue() instanceof Number)) continue;
            compoundTag.m_128347_((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
        }
        ArrayList<ItemStack> outputs1 = new ArrayList<ItemStack>();
        outputs.forEach(outputs2 -> {
            if (!(outputs2 instanceof InputFluidStack)) {
                outputs1.add(outputs2.getInputs().get(0));
            }
        });
        if (!inputs.isEmpty() && fluidStacks.isEmpty()) {
            Recipes.recipes.addAdderRecipe(recipeType, new BaseMachineRecipe(new Input(inputs), new RecipeOutput(compoundTag, outputs1)));
        } else if (!inputs.isEmpty() && !isFluidRecipe) {
            Recipes.recipes.addAdderRecipe(recipeType, new BaseMachineRecipe(new Input((FluidStack)fluidStacks.get(0), inputs), new RecipeOutput(compoundTag, outputs1)));
        } else if (inputs.isEmpty() && isFluidRecipe) {
            if (!outputs1.isEmpty() && outputsFluid.isEmpty()) {
                Recipes.recipes.addFluidAdderRecipe(recipeType, new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStacks.toArray(new FluidStack[0])), new RecipeOutput(compoundTag, outputs1)));
            } else if (!outputs1.isEmpty() && !outputsFluid.isEmpty()) {
                Recipes.recipes.addFluidAdderRecipe(recipeType, new BaseFluidMachineRecipe(new InputFluid(fluidStacks.toArray(new FluidStack[0])), new RecipeOutput(compoundTag, outputs1), outputsFluid));
            } else if (outputs1.isEmpty() && !outputsFluid.isEmpty()) {
                Recipes.recipes.addFluidAdderRecipe(recipeType, new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStacks.toArray(new FluidStack[0])), outputsFluid));
            }
        } else if (!inputs.isEmpty() && isFluidRecipe) {
            Recipes.recipes.addAdderRecipe(recipeType, new BaseMachineRecipe(new Input((FluidStack)fluidStacks.get(0), inputs), new RecipeOutput(compoundTag, outputs1)));
            if (!outputs1.isEmpty() && outputsFluid.isEmpty()) {
                Recipes.recipes.addFluidAdderRecipe(recipeType, new BaseFluidMachineRecipe((IInputFluid)new InputFluid(((IInputItemStack)inputs.get(0)).getInputs().get(0), fluidStacks.toArray(new FluidStack[0])), new RecipeOutput(compoundTag, outputs1)));
            } else if (!outputs1.isEmpty() && !outputsFluid.isEmpty()) {
                Recipes.recipes.addFluidAdderRecipe(recipeType, new BaseFluidMachineRecipe(new InputFluid(((IInputItemStack)inputs.get(0)).getInputs().get(0), fluidStacks.toArray(new FluidStack[0])), new RecipeOutput(compoundTag, outputs1), outputsFluid));
            } else if (outputs1.isEmpty() && !outputsFluid.isEmpty()) {
                Recipes.recipes.addFluidAdderRecipe(recipeType, new BaseFluidMachineRecipe((IInputFluid)new InputFluid(((IInputItemStack)inputs.get(0)).getInputs().get(0), fluidStacks.toArray(new FluidStack[0])), outputsFluid));
            }
        }
        return new IURecipe(id, recipeType, inputs, outputs1, params);
    }

    public IURecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        return new IURecipe(id, "", new ArrayList<IInputItemStack>(), new ArrayList<ItemStack>(), new HashMap<String, Object>());
    }

    public void toNetwork(FriendlyByteBuf buf, IURecipe recipe) {
    }
}

