/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.Asteroid;
import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IStar;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.AsteroidRecipe;
import com.denfop.recipe.universalrecipe.PlanetSerializer;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AsteroidSerializer
implements RecipeSerializer<AsteroidRecipe> {
    public static final AsteroidSerializer INSTANCE = new AsteroidSerializer();

    public AsteroidRecipe fromJson(ResourceLocation id, JsonObject json) {
        String name = json.get("name").getAsString();
        String systemStr = json.get("system").getAsString();
        String textureStr = json.get("texture").getAsString();
        EnumLevels level = EnumLevels.valueOf(json.get("level").getAsString().toUpperCase());
        String starStr = json.get("star").getAsString();
        int temperature = json.get("temperature").getAsInt();
        double minLocation = json.get("minLocation").getAsDouble();
        double distance = json.get("distance").getAsDouble();
        EnumType type = EnumType.valueOf(json.get("type").getAsString().toUpperCase());
        double maxLocation = json.get("maxLocation").getAsDouble();
        boolean colonies = json.get("colonies").getAsBoolean();
        int angle = json.get("angle").getAsInt();
        int amount = json.get("amount").getAsInt();
        double time = json.get("time").getAsDouble();
        double size = json.get("size").getAsDouble();
        double rotation = json.get("rotation").getAsDouble();
        ResourceLocation texture = ResourceLocation.m_135820_((String)(textureStr + ".png"));
        if (!PlanetSerializer.stringList.contains("asteroid_" + name)) {
            SpaceInit.regAsteroid.add(() -> new Asteroid(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr)), texture, level, (IStar)SpaceNet.instance.getBodyFromName(starStr), temperature, distance, type, colonies, angle, time, size, rotation, minLocation, maxLocation, amount));
            PlanetSerializer.stringList.add("asteroid_" + name);
        }
        return new AsteroidRecipe(id, name, systemStr, textureStr, level, starStr, temperature, distance, type, colonies, angle, time, size, rotation, minLocation, maxLocation, amount);
    }

    public AsteroidRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        String name = buf.m_130277_();
        String systemName = buf.m_130277_();
        String texturePath = buf.m_130277_();
        EnumLevels level = EnumLevels.valueOf(buf.m_130277_().toUpperCase());
        String starName = buf.m_130277_();
        int temperature = buf.m_130242_();
        double distance = buf.readDouble();
        EnumType type = EnumType.valueOf(buf.m_130277_().toUpperCase());
        boolean colonies = buf.readBoolean();
        int angle = buf.m_130242_();
        double time = buf.readDouble();
        double size = buf.readDouble();
        double rotation = buf.readDouble();
        double minLocation = buf.readDouble();
        double maxLocation = buf.readDouble();
        int amount = buf.m_130242_();
        if (!PlanetSerializer.stringList.contains("asteroid_" + name)) {
            SpaceInit.regAsteroid.add(() -> new Asteroid(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemName.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemName)), ResourceLocation.m_135820_((String)texturePath), level, (IStar)SpaceNet.instance.getBodyFromName(starName), temperature, distance, type, colonies, angle, time, size, rotation, minLocation, maxLocation, amount));
            PlanetSerializer.stringList.add("asteroid_" + name);
        }
        return new AsteroidRecipe(id, name, systemName, texturePath, level, starName, temperature, distance, type, colonies, angle, time, size, rotation, minLocation, maxLocation, amount);
    }

    public void toNetwork(FriendlyByteBuf buf, AsteroidRecipe recipe) {
        buf.m_130070_(recipe.name);
        buf.m_130070_(recipe.systemName);
        buf.m_130070_(recipe.texturePath);
        buf.m_130070_(recipe.level.name());
        buf.m_130070_(recipe.starName);
        buf.m_130130_(recipe.temperature.intValue());
        buf.writeDouble(recipe.distance.doubleValue());
        buf.m_130070_(recipe.type.name());
        buf.writeBoolean(recipe.colonies.booleanValue());
        buf.m_130130_(recipe.angle.intValue());
        buf.writeDouble(recipe.time.doubleValue());
        buf.writeDouble(recipe.size.doubleValue());
        buf.writeDouble(recipe.rotation.doubleValue());
        buf.writeDouble(recipe.minLocation.doubleValue());
        buf.writeDouble(recipe.maxLocation.doubleValue());
        buf.m_130130_(recipe.amount.intValue());
    }
}

