/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.crafting.BaseShapelessRecipe;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class IndustrialShapelessRecipeSerializer
implements RecipeSerializer<BaseShapelessRecipe> {
    public BaseShapelessRecipe fromJson(ResourceLocation id, JsonObject json) {
        String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
        CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
        JsonArray ingredientsJson = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
        if (ingredientsJson.size() == 0) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredientsJson.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is 9");
        }
        ArrayList<IInputItemStack> inputList = new ArrayList<IInputItemStack>();
        for (JsonElement element : ingredientsJson) {
            Ingredient ingredient = Ingredient.m_288218_((JsonElement)element, (boolean)false);
            IInputItemStack input = Recipes.inputFactory.getInput(ingredient);
            inputList.add(input);
        }
        ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        return new BaseShapelessRecipe(id, group, category, result, inputList);
    }

    @Nullable
    public BaseShapelessRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf pBuffer) {
        return BaseShapelessRecipe.create(id, new CustomPacketBuffer((ByteBuf)pBuffer));
    }

    public void toNetwork(FriendlyByteBuf buf, BaseShapelessRecipe recipe) {
        recipe.toNetwork(buf);
    }
}

