/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.storage.Controller;
import com.denfop.api.storage.autocrafting.SameStack;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class PacketUpdateStorageCell
implements IPacket {
    public PacketUpdateStorageCell() {
    }

    public PacketUpdateStorageCell(List<SameStack> stacks, boolean isFluid, boolean canCreate, BlockPos pos, Level level) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, pos);
            EncoderHandler.encode(customPacketBuffer, level);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        customPacketBuffer.writeBoolean(isFluid);
        customPacketBuffer.writeBoolean(canCreate);
        customPacketBuffer.writeInt(stacks.size());
        for (SameStack stack : stacks) {
            try {
                if (!isFluid) {
                    EncoderHandler.encode(customPacketBuffer, stack.getStack());
                    continue;
                }
                EncoderHandler.encode(customPacketBuffer, stack.getFluidStack());
            }
            catch (IOException iOException) {}
        }
        IUCore.network.getServer().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 110;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockEntity blockEntity;
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            Level level = (Level)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.m_9236_().m_46472_() == level.m_46472_() && (blockEntity = entityPlayer.m_9236_().m_7702_(pos)) instanceof Controller) {
                Controller controller = (Controller)blockEntity;
                boolean isFluid = customPacketBuffer.readBoolean();
                boolean isCreate = customPacketBuffer.readBoolean();
                int size = customPacketBuffer.readInt();
                LinkedList<SameStack> stacks = new LinkedList<SameStack>();
                for (int i = 0; i < size; ++i) {
                    try {
                        if (!isFluid) {
                            stacks.add(new SameStack((ItemStack)DecoderHandler.decode(customPacketBuffer)));
                            continue;
                        }
                        stacks.add(new SameStack((FluidStack)DecoderHandler.decode(customPacketBuffer)));
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                controller.setStack(isFluid, isCreate, new ArrayList<SameStack>(stacks));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

