/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.blockentity.mechanism.BlockEntityResearchTableSpace;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketUpdateBody
implements IPacket {
    public PacketUpdateBody() {
    }

    public PacketUpdateBody(BlockEntityResearchTableSpace tile, IBody body) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, tile.getWorld());
            EncoderHandler.encode(customPacketBuffer, tile.getPos());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        customPacketBuffer.writeBoolean(body != null);
        if (body != null) {
            customPacketBuffer.writeString(body.getName());
        }
        tile.body = body;
        IUCore.network.getClient().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 40;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            Level world = (Level)DecoderHandler.decode(customPacketBuffer);
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof BlockEntityResearchTableSpace) {
                BlockEntityResearchTableSpace tileEntityResearchTableSpace = (BlockEntityResearchTableSpace)tile;
                boolean hasBody = customPacketBuffer.readBoolean();
                if (hasBody) {
                    tileEntityResearchTableSpace.body = SpaceNet.instance.getBodyFromName(customPacketBuffer.readString());
                    if (tileEntityResearchTableSpace.fakeBody != null && !tileEntityResearchTableSpace.fakeBody.matched(tileEntityResearchTableSpace.body)) {
                        tileEntityResearchTableSpace.fakeBody = null;
                    }
                } else {
                    tileEntityResearchTableSpace.fakeBody = null;
                    tileEntityResearchTableSpace.body = null;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

