/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blockentity.storage.BlockEntityMonitor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.network.packet.PackerUpdateClientRemoveStack;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketRemoveStack
implements IPacket {
    public PacketRemoveStack() {
    }

    public PacketRemoveStack(Player player, ItemStack stack, Level level, BlockPos pos) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, pos);
            EncoderHandler.encode(customPacketBuffer, level);
            EncoderHandler.encode(customPacketBuffer, player.m_20148_());
            EncoderHandler.encode(customPacketBuffer, stack);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IUCore.network.getClient().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 112;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockEntity blockEntity;
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            Level level = (Level)DecoderHandler.decode(customPacketBuffer);
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            ItemStack stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.m_20148_().equals(uuid) && (blockEntity = entityPlayer.m_9236_().m_7702_(pos)) instanceof BlockEntityMonitor) {
                BlockEntityMonitor controller = (BlockEntityMonitor)blockEntity;
                if (controller.network != null) {
                    int count = controller.network.canRemove(stack);
                    stack.m_41764_(count);
                    controller.network.removeStack(stack);
                    entityPlayer.f_36096_.m_142503_(stack);
                    new PackerUpdateClientRemoveStack(entityPlayer, stack);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

