/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blockentity.storage.BlockEntityMonitor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketRemoveShiftStack
implements IPacket {
    public PacketRemoveShiftStack() {
    }

    public PacketRemoveShiftStack(Player player, ItemStack stack, Level level, BlockPos pos) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, pos);
            EncoderHandler.encode(customPacketBuffer, level);
            EncoderHandler.encode(customPacketBuffer, player.m_20148_());
            EncoderHandler.encode(customPacketBuffer, stack);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IUCore.network.getClient().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 116;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockEntity blockEntity;
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            Level level = (Level)DecoderHandler.decode(customPacketBuffer);
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            ItemStack stack = (ItemStack)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.m_20148_().equals(uuid) && (blockEntity = entityPlayer.m_9236_().m_7702_(pos)) instanceof BlockEntityMonitor) {
                BlockEntityMonitor controller = (BlockEntityMonitor)blockEntity;
                if (controller.network != null) {
                    int count = controller.network.canRemove(stack);
                    stack.m_41764_(count);
                    ItemStack stack1 = stack.m_41777_();
                    ItemStack stack2 = this.addItemStackToInventory(entityPlayer, stack1);
                    if (stack.m_41613_() - stack2.m_41613_() != 0) {
                        stack.m_41764_(stack.m_41613_() - stack2.m_41613_());
                        controller.network.removeStack(stack);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ItemStack addItemStackToInventory(Player player, ItemStack stack) {
        ItemStack slot;
        int i;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Inventory inv = player.m_150109_();
        for (i = 0; i < inv.f_35974_.size(); ++i) {
            int transferable;
            slot = (ItemStack)inv.f_35974_.get(i);
            if (slot.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)slot) || (transferable = Math.min(stack.m_41613_(), slot.m_41741_() - slot.m_41613_())) <= 0) continue;
            slot.m_41769_(transferable);
            stack.m_41774_(transferable);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        for (i = 0; i < inv.f_35974_.size(); ++i) {
            slot = (ItemStack)inv.f_35974_.get(i);
            if (!slot.m_41619_()) continue;
            int toPut = Math.min(stack.m_41613_(), stack.m_41741_());
            inv.f_35974_.set(i, (Object)stack.m_41620_(toPut));
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

