/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blockentity.storage.BlockEntityController;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketCreateNetwork
implements IPacket {
    public PacketCreateNetwork() {
    }

    public PacketCreateNetwork(BlockPos pos, Level level, List<BlockPos> blockPoses) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, pos);
            EncoderHandler.encode(customPacketBuffer, level);
            EncoderHandler.encode(customPacketBuffer, blockPoses);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IUCore.network.getServer().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 111;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockEntity blockEntity;
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            Level level = (Level)DecoderHandler.decode(customPacketBuffer);
            List blockPoses = (List)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.m_9236_().m_46472_() == level.m_46472_() && (blockEntity = entityPlayer.m_9236_().m_7702_(pos)) instanceof BlockEntityController) {
                BlockEntityController controller = (BlockEntityController)blockEntity;
                controller.networkSystem.reBuild(entityPlayer.m_9236_(), blockPoses);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

