/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blockentity.storage.BlockEntityMonitor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.network.packet.PacketCanAddCraftClient;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketCanAddCraft
implements IPacket {
    public PacketCanAddCraft() {
    }

    public PacketCanAddCraft(Player player, BlockPos pos) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, player.m_20148_());
            EncoderHandler.encode(customPacketBuffer, pos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        IUCore.network.getClient().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 118;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            BlockEntity blockEntity;
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.m_20148_().equals(uuid) && (blockEntity = entityPlayer.m_9236_().m_7702_(pos)) instanceof BlockEntityMonitor) {
                BlockEntityMonitor controller = (BlockEntityMonitor)blockEntity;
                if (controller.network != null) {
                    boolean canAdd = controller.network.hasAvailableProcessors();
                    new PacketCanAddCraftClient(entityPlayer, canAdd);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

