/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.api.pollution.radiation.Radiation;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IInput;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.vein.common.VeinBase;
import com.denfop.blockentity.base.DataOre;
import com.denfop.componets.AbstractComponent;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.INetworkObject;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public enum EncodedType {
    Null(null),
    Array(null),
    Byte(Byte.class),
    Short(Short.class),
    Integer(Integer.class),
    Long(Long.class),
    Float(Float.class),
    Double(Double.class),
    Boolean(Boolean.class),
    Character(Character.class),
    network_object(INetworkObject.class),
    String(String.class),
    Enum(Enum.class),
    UUID(UUID.class),
    Block(Block.class),
    Item(Item.class),
    TileEntity(BlockEntity.class, false),
    ItemStack(ItemStack.class),
    World(Level.class, false),
    NBTTagCompound(CompoundTag.class),
    tuple(Tuple.class),
    ResourceLocation(ResourceLocation.class),
    GameProfile(GameProfile.class),
    Potion(Potion.class),
    Enchantment(Enchantment.class),
    BlockPos(BlockPos.class),
    ChunkPos(ChunkPos.class),
    Vec3(Vec3.class),
    Fluid(Fluid.class),
    Vein(VeinBase.class),
    MachineRecipe(BaseMachineRecipe.class),
    FluidStack(FluidStack.class),
    FluidTank(FluidTank.class),
    InvSlot(Inventory.class),
    Component(AbstractComponent.class, false),
    Radiation(Radiation.class),
    Collection(Collection.class),
    RecipeInfo(RecipeInfo.class),
    DataOre(DataOre.class),
    BaseRecipe(BaseMachineRecipe.class),
    BaseFluidRecipe(BaseFluidMachineRecipe.class),
    recipeOutput(RecipeOutput.class),
    inputStack(IInput.class),
    inputFluidStack(IInputFluid.class),
    Object(Object.class);

    public static final EncodedType[] types;
    public static final Map<Class<?>, EncodedType> classToTypeMap;
    public final Class<?> cls;
    public final boolean threadSafe;

    private EncodedType(Class<?> cls) {
        this(cls, true);
    }

    private EncodedType(Class<?> cls, boolean threadSafe) {
        this.cls = cls;
        this.threadSafe = threadSafe;
    }

    static {
        types = EncodedType.values();
        classToTypeMap = new IdentityHashMap(types.length - 2);
        for (EncodedType type : types) {
            if (type.cls == null) continue;
            classToTypeMap.put(type.cls, type);
        }
        if (types.length > 255) {
            throw new RuntimeException("too many types");
        }
    }
}

