/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.api.item.energy.EnergyItem;
import com.denfop.items.energy.ItemToolIU;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.ModUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public abstract class ItemEnergyTool
extends ItemToolIU
implements EnergyItem {
    public final int operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    private String nameItem;

    public ItemEnergyTool(int operationEnergyCost) {
        this(2.0f, -3.0f, operationEnergyCost, (TagKey<Block>)Tags.Blocks.GLASS);
    }

    public ItemEnergyTool(float damage, float speed, int operationEnergyCost, TagKey<Block> mineableBlocks) {
        super(damage, speed, mineableBlocks);
        this.operationEnergyCost = operationEnergyCost;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }

    @Override
    protected String m_41467_() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.m_137492_((String)"iu", (ResourceLocation)BuiltInRegistries.f_257033_.m_7981_((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142159_(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    public int m_142158_(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public float m_8102_(ItemStack p_41004_, BlockState p_41005_) {
        return !ElectricItem.manager.canUse(p_41004_, this.operationEnergyCost) ? 0.1f : super.m_8102_(p_41004_, p_41005_);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity user) {
        if (state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            ElectricItem.manager.use(stack, this.operationEnergyCost, user);
        }
        return true;
    }
}

