/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.book;

import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.guidebook.Quest;
import com.denfop.api.widget.FluidDefaultWidget;
import com.denfop.api.widget.ItemStackWidget;
import com.denfop.api.widget.ItemWidget;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.items.book.ScreenBook;
import com.denfop.network.packet.PacketUpdateCompleteQuest;
import com.denfop.network.packet.PacketUpdateSkipQuest;
import com.denfop.screen.ScreenResearchTableSpace;
import com.denfop.toast.GuideToast;
import com.denfop.utils.Localization;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class GuideQuest {
    private final Quest quest;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final Player player;
    private final int tab;
    private final int id;
    List<ItemStack> stacks = new ArrayList<ItemStack>();
    private boolean isUnlocked = false;
    private int offsetX1 = 0;
    private int offsetY1 = 0;
    private int maxPage = 1;
    private int page = 1;
    private int maxItemPage = 1;
    private int itemPage = 1;
    private int lastMouseX1;
    private int lastMouseY1;
    private boolean hover = false;
    private boolean hoverBookMark = false;
    private boolean hoverButton = false;
    private boolean hoverSkip = false;

    public GuideQuest(Quest quest, int tab, int id) {
        this.quest = quest;
        this.x = 25;
        this.y = 25;
        this.width = 208;
        this.height = 176;
        this.tab = tab;
        this.id = id;
        this.player = null;
    }

    public GuideQuest(Quest quest, Player player, boolean isUnlocked, int tab, int id) {
        this.quest = quest;
        this.x = 25;
        this.y = 25;
        this.tab = tab;
        this.id = id;
        this.width = 208;
        this.height = 176;
        this.isUnlocked = isUnlocked;
        for (ItemStack stack : quest.itemStacks) {
            boolean merged = false;
            for (ItemStack existing : this.stacks) {
                if (!ItemStack.m_41656_((ItemStack)existing, (ItemStack)stack)) continue;
                existing.m_41769_(stack.m_41613_());
                merged = true;
                break;
            }
            if (merged) continue;
            this.stacks.add(stack.m_41777_());
        }
        this.player = player;
    }

    public boolean isUnlocked() {
        return this.isUnlocked;
    }

    public boolean hasAllItems(Player player, List<ItemStack> requiredItems) {
        for (FluidStack fluidStack : this.getQuest().fluidStacks) {
            int amount = fluidStack.getAmount();
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                IFluidHandlerItem handler;
                ItemStack inInventory = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (FluidUtil.getFluidHandler((ItemStack)inInventory).orElse(null) == null || (handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)inInventory).orElse(null)).getFluidInTank(0).isEmpty() || !handler.getFluidInTank(0).isFluidEqual(fluidStack)) continue;
                if (handler.getFluidInTank(0).getAmount() < fluidStack.getAmount()) {
                    amount -= handler.getFluidInTank(0).getAmount();
                    continue;
                }
                amount = 0;
                break;
            }
            if (amount == 0) continue;
            return false;
        }
        for (ItemStack required : requiredItems) {
            ItemStack inInventory;
            int neededCount = required.m_41613_();
            int foundCount = 0;
            for (int i = 0; !(i >= player.m_150109_().f_35974_.size() || ItemStack.m_41656_((ItemStack)(inInventory = (ItemStack)player.m_150109_().f_35974_.get(i)), (ItemStack)required) && (foundCount += inInventory.m_41613_()) >= neededCount); ++i) {
            }
            if (foundCount >= neededCount) continue;
            return false;
        }
        return true;
    }

    public void drawForegroundLayer(ScreenBook guiIU, GuiGraphics poseStack, int x, int y) {
        int startX = x;
        int startY = y;
        this.hover = startX >= this.x + this.offsetX1 + 191 && startX <= this.x + this.offsetX1 + 191 + 13 && startY >= this.y + this.offsetY1 + 4 && startY <= this.y + this.offsetY1 + 15;
        this.hoverButton = startX >= this.x + this.offsetX1 + 15 && startX <= this.x + this.offsetX1 + 34 && startY >= this.y + this.offsetY1 + 37 && startY <= this.y + this.offsetY1 + 55;
        this.hoverSkip = startX >= this.x + this.offsetX1 + 50 && startX <= this.x + this.offsetX1 + 50 + 206 - 68 && startY >= this.y + this.offsetY1 + 42 && startY <= this.y + this.offsetY1 + 42 + 196 - 182;
        this.hoverBookMark = startX >= this.x + this.offsetX1 + 195 && startX <= this.x + this.offsetX1 + 195 + 11 && startY >= this.y + this.offsetY1 + 17 && startY <= this.y + this.offsetY1 + 17 + 11;
        int j = -1;
        int size = this.quest.itemStacks.size() + this.quest.fluidStacks.size();
        poseStack.m_280168_().m_85836_();
        poseStack.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        for (int i = (this.itemPage - 1) * 11; i < Math.min(this.itemPage * 11, size); ++i) {
            int finalI;
            ++j;
            if (i < this.quest.itemStacks.size()) {
                finalI = i;
                new ItemStackWidget(guiIU, this.x + this.offsetX1 + 6 + j * 18, this.y + this.offsetY1 + 64, () -> this.quest.itemStacks.get(finalI)).drawForeground(poseStack, x, y);
                continue;
            }
            finalI = i - this.quest.itemStacks.size();
            new FluidDefaultWidget(guiIU, this.x + this.offsetX1 + 6 + j * 18, this.y + this.offsetY1 + 64, this.quest.fluidStacks.get(finalI)).drawForeground(poseStack, x, y);
        }
        poseStack.m_280168_().m_85849_();
    }

    public boolean isRemove(int x, int y) {
        int startX = x;
        int startY = y;
        return startX >= this.x + this.offsetX1 + 191 && startX <= this.x + this.offsetX1 + 191 + 13 && startY >= this.y + this.offsetY1 + 4 && startY <= this.y + this.offsetY1 + 15;
    }

    public int getLastMouseX1() {
        return this.lastMouseX1;
    }

    public void setLastMouseX1(int lastMouseX1) {
        this.lastMouseX1 = lastMouseX1;
    }

    public int getLastMouseY1() {
        return this.lastMouseY1;
    }

    public void setLastMouseY1(int lastMouseY1) {
        this.lastMouseY1 = lastMouseY1;
    }

    public int getOffsetX1() {
        return this.offsetX1;
    }

    public void setOffsetX1(int offsetX1) {
        this.offsetX1 = offsetX1;
    }

    public int getOffsetY1() {
        return this.offsetY1;
    }

    public void setOffsetY1(int offsetY1) {
        this.offsetY1 = offsetY1;
    }

    public boolean is(int x, int y) {
        int tempX = this.x + this.offsetX1;
        int tempy = this.y + this.offsetY1;
        return tempX <= x && tempy <= y && y <= tempy + this.height && x <= tempX + this.width;
    }

    public void drawBackgroundLayer(ScreenBook guiIU, GuiGraphics poseStack, int mouseX, int mouseY, boolean isComplete) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenBook.bindTexture(ScreenBook.background1);
        guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1, mouseY + this.y + this.offsetY1, 0, 0, this.width, this.height);
        if (this.hover) {
            guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 191, mouseY + this.y + this.offsetY1 + 4, 243, 12, 13, 12);
        } else {
            guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 191, mouseY + this.y + this.offsetY1 + 4, 243, 0, 13, 12);
        }
        if (isComplete) {
            guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 15, mouseY + this.y + this.offsetY1 + 37, 236, 85, 20, 19);
        } else if (this.hasAllItems(this.player, this.stacks) && !this.isUnlocked()) {
            if (!this.hoverButton) {
                guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 15, mouseY + this.y + this.offsetY1 + 37, 236, 25, 20, 19);
            } else {
                guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 15, mouseY + this.y + this.offsetY1 + 37, 236, 45, 20, 19);
            }
        } else {
            guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 15, mouseY + this.y + this.offsetY1 + 37, 236, 65, 20, 19);
        }
        String name = this.quest.getLocalizedName();
        int textWidth = guiIU.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.m_280168_();
        pose.m_85836_();
        pose.m_85841_(scale, scale, 1.0f);
        int centerX = mouseX + this.x + this.offsetX1 + 5 + this.width / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(mouseY + this.y + this.offsetY1 + 5) / scale);
        poseStack.m_280056_(Minecraft.m_91087_().f_91062_, ChatFormatting.WHITE + name, textX, textY, 0, false);
        pose.m_85841_(1.0f / scale, 1.0f / scale, 1.0f);
        pose.m_85849_();
        guiIU.drawString(poseStack, ChatFormatting.GREEN + Localization.translate("iu.quest.task." + this.quest.typeQuest.name().toLowerCase()), mouseX + this.x + this.offsetX1 + 5 + this.width / 2 - guiIU.getStringWidth("iu.quest.task." + this.quest.typeQuest.name().toLowerCase()) / 2, mouseY + this.y + this.offsetY1 + 25, 0);
        new ItemWidget(guiIU, this.x + this.offsetX1 + 17, this.y + this.offsetY1 + 16, (Supplier<ItemStack>)((Supplier)() -> this.quest.icon)).drawBackground(poseStack, mouseX, mouseY);
        List<String> lines = guiIU.splitTextToLines(this.quest.getLocalizedDescription(), this.width - 15, 1.0f);
        this.maxPage = Math.max(1, lines.size() - 6);
        this.maxItemPage = Math.max(1, 1 + (this.quest.fluidStacks.size() + this.quest.itemStacks.size()) / 11);
        this.enableScissor(guiIU, mouseX + this.x + this.offsetX1 + 6, mouseY + this.y + this.offsetY1 + 90, this.width - 15, 70);
        guiIU.drawTextInCanvasWithScissor(poseStack, this.quest.getLocalizedDescription(), mouseX + this.x + this.offsetX1 + 6, mouseY + this.y + this.offsetY1 + 90, this.width - 15, 70, this.page);
        this.disableScissor(guiIU);
        guiIU.drawString(poseStack, this.page + "/" + this.maxPage, mouseX + this.x + this.offsetX1 + 5 + this.width / 2 - guiIU.getStringWidth(this.page + "/" + this.maxPage) / 2, mouseY + this.y + this.offsetY1 + 162, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenBook.bindTexture(ScreenBook.background1);
        int scroll = (int)Math.ceil(71.0 / (double)this.maxPage);
        guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 200, mouseY + this.y + this.offsetY1 + 94 + (this.page - 1) * 71 / this.maxPage, 232, 1, 3, scroll);
        scroll = (int)Math.ceil(11.0 / (double)this.maxItemPage);
        guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 200, mouseY + this.y + this.offsetY1 + 67 + (this.itemPage - 1) * 11 / this.maxItemPage, 232, 1, 3, scroll);
        int j = -1;
        int size = this.quest.itemStacks.size() + this.quest.fluidStacks.size();
        for (int i = (this.itemPage - 1) * 11; i < Math.min(this.itemPage * 11, size); ++i) {
            int finalI;
            ++j;
            if (i < this.quest.itemStacks.size()) {
                finalI = i;
                new ItemStackWidget(guiIU, this.x + this.offsetX1 + 6 + j * 18, this.y + this.offsetY1 + 64, () -> this.quest.itemStacks.get(finalI)).drawBackground(poseStack, mouseX, mouseY);
                continue;
            }
            finalI = i - this.quest.itemStacks.size();
            new FluidDefaultWidget(guiIU, this.x + this.offsetX1 + 6 + j * 18, this.y + this.offsetY1 + 64, this.quest.fluidStacks.get(finalI)).drawBackground(poseStack, mouseX, mouseY);
        }
        ScreenBook.bindTexture(ScreenBook.background1);
        if (!(this.isUnlocked || this.getQuest().itemStacks.isEmpty() && this.getQuest().fluidStacks.isEmpty())) {
            guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 50, mouseY + this.y + this.offsetY1 + 42, 68, 182, 138, 14);
            if (this.hoverSkip) {
                guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 50, mouseY + this.y + this.offsetY1 + 42, 68, 201, 138, 14);
            }
            guiIU.drawString(poseStack, ChatFormatting.GREEN + Localization.translate("iu.quest.task.skip"), mouseX + this.x + this.offsetX1 + 5 + this.width / 2 - guiIU.getStringWidth("iu.quest.task." + this.quest.typeQuest.name().toLowerCase()) / 2, mouseY + this.y + this.offsetY1 + 45, 0);
        }
        guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 195, mouseY + this.y + this.offsetY1 + 17, 245, 149, 11, 11);
        if (guiIU.hasBookMark(this.tab, this.id)) {
            guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 195, mouseY + this.y + this.offsetY1 + 17, 245, 122, 11, 11);
            if (this.hoverBookMark) {
                guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 194, mouseY + this.y + this.offsetY1 + 16, 244, 134, 11, 13);
            }
        } else {
            guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 195, mouseY + this.y + this.offsetY1 + 17, 245, 149, 11, 11);
            if (this.hoverBookMark) {
                guiIU.drawTexturedModalRect(poseStack, mouseX + this.x + this.offsetX1 + 194, mouseY + this.y + this.offsetY1 + 16, 244, 108, 11, 13);
            }
        }
    }

    private void enableScissor(ScreenBook book, int x, int y, int width, int height) {
        ScreenResearchTableSpace.enableScissor(x, y, x + width, y + height);
    }

    private void disableScissor(ScreenBook book) {
        RenderSystem.disableScissor();
    }

    public boolean isTextFields(int x, int y) {
        int tempX = this.x + this.offsetX1 + 6;
        int tempy = this.y + this.offsetY1 + 90;
        return tempX <= x && tempy <= y && y <= tempy + 90 + 70 && x <= tempX + this.width;
    }

    public void scroll(ScrollDirection direction) {
        if (direction == ScrollDirection.down) {
            ++this.page;
            this.page = Math.min(this.page, this.maxPage);
        } else {
            --this.page;
            this.page = Math.max(1, this.page);
        }
    }

    public void scrollItem(ScrollDirection direction) {
        if (direction == ScrollDirection.down) {
            ++this.itemPage;
            this.itemPage = Math.min(this.itemPage, this.maxItemPage);
        } else {
            --this.itemPage;
            this.itemPage = Math.max(1, this.itemPage);
        }
    }

    public Quest getQuest() {
        return this.quest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Quest) {
            Quest that = (Quest)o;
            return Objects.equals(this.quest, that);
        }
        if (o instanceof GuideQuest) {
            GuideQuest that = (GuideQuest)o;
            return Objects.equals(this.quest, that.quest);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.quest);
    }

    public boolean isItems(int x, int y) {
        int tempX = this.x + this.offsetX1 + 6;
        int tempy = this.y + this.offsetY1 + 63;
        return tempX <= x && tempy <= y && y <= tempy + 20 && x <= tempX + this.width;
    }

    public boolean canScroll(ScrollDirection direction) {
        int page = this.page;
        if (direction == ScrollDirection.down) {
            ++page;
            page = Math.min(page, this.maxPage);
        } else {
            --page;
            page = Math.max(1, page);
        }
        return page != this.page;
    }

    public boolean canScrollItem(ScrollDirection direction) {
        int itemPage = this.itemPage;
        if (direction == ScrollDirection.down) {
            ++itemPage;
            itemPage = Math.min(itemPage, this.maxItemPage);
        } else {
            --itemPage;
            itemPage = Math.max(1, itemPage);
        }
        return itemPage != this.itemPage;
    }

    public boolean isComplete(Player player, int tab) {
        if (this.hasAllItems(player, this.stacks) && this.hoverButton && !this.isUnlocked) {
            return GuideBookCore.uuidGuideMap.get(player.m_20148_()).get(GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized).contains(this.quest.unLocalizedName);
        }
        return false;
    }

    public void complete(Player player, int tab) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new GuideToast(this.quest));
        new PacketUpdateCompleteQuest(player, GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized, this.quest.unLocalizedName);
    }

    public boolean isSkip(Player player, int tab) {
        if (!(!this.hoverSkip || this.isUnlocked || this.getQuest().itemStacks.isEmpty() && this.getQuest().fluidStacks.isEmpty())) {
            return GuideBookCore.uuidGuideMap.get(player.m_20148_()).get(GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized).contains(this.quest.unLocalizedName);
        }
        return false;
    }

    public void skip(Player player, int tab) {
        Minecraft.m_91087_().m_91300_().m_94922_((Toast)new GuideToast(this.quest));
        new PacketUpdateSkipQuest(player, GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized, this.quest.unLocalizedName);
    }

    public boolean isBookMark(Player player, int tab) {
        return this.hoverBookMark;
    }

    public void bookMark(ScreenBook book, int tab) {
        if (book.hasBookMark(this.tab, this.id)) {
            book.removeBookMark(this.tab, this.id);
        } else {
            book.addBookMark(this.tab, this.id);
        }
    }
}

