/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bags;

import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.containermenu.ContainerMenuBags;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.bags.BagsDescription;
import com.denfop.items.bags.ItemEnergyBags;
import com.denfop.screen.ScreenBags;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemStackBags
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    public final ItemStack[] list = new ItemStack[9];
    private final double coef;

    public ItemStackBags(Player player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        Arrays.fill(this.list, ItemStack.f_41583_);
        this.inventorySize = inventorySize;
        this.itemStack1 = stack;
        if (!player.m_9236_().m_5776_()) {
            CompoundTag nbt = ModUtils.nbt(this.containerStack);
            ListTag contentList = nbt.m_128437_("Items1", 10);
            for (int i = 0; i < contentList.size(); ++i) {
                CompoundTag slotNbt = contentList.m_128728_(i);
                byte slot = slotNbt.m_128445_("Slot");
                if (slot < 0 || slot >= this.list.length) continue;
                this.list[slot] = ItemStack.m_41712_((CompoundTag)slotNbt);
            }
        }
        this.coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
    }

    @Override
    public ItemStack m_8020_(int slot) {
        return slot >= this.inventorySize ? this.list[slot - this.inventorySize] : this.inventory[slot];
    }

    @Override
    public void save() {
        super.save();
        if (!this.player.m_9236_().f_46443_ && !this.cleared) {
            int idx;
            boolean dropItself = false;
            for (int i = 0; i < this.list.length; ++i) {
                if (!this.isThisContainer(this.list[i])) continue;
                this.list[i] = ItemStack.f_41583_;
                dropItself = true;
            }
            ListTag contentList = new ListTag();
            for (idx = 0; idx < this.list.length; ++idx) {
                if (ModUtils.isEmpty(this.list[idx])) continue;
                CompoundTag nbt = new CompoundTag();
                nbt.m_128344_("Slot", (byte)idx);
                this.list[idx].m_41739_(nbt);
                contentList.add((Object)nbt);
            }
            ModUtils.nbt(this.containerStack).m_128365_("Items1", (Tag)contentList);
            this.containerStack = ModUtils.setSize(this.containerStack, 1);
            if (dropItself) {
                ModUtils.dropAsEntity(this.player.m_9236_(), this.player.m_20183_(), this.containerStack);
                this.clear();
            } else {
                idx = this.getPlayerInventoryIndex();
                if (idx < -1) {
                    this.clear();
                } else if (idx == -1) {
                    this.player.m_150109_().m_36012_(this.containerStack);
                } else {
                    this.player.m_150109_().m_6836_(idx, this.containerStack);
                }
            }
        }
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        if (slot < this.inventory.length) {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
                stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
            }
            this.inventory[slot] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        } else {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.getInventoryStackLimit()) {
                stack = ModUtils.setSize(stack, this.getInventoryStackLimit());
            }
            this.list[slot - this.inventory.length] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        }
        this.updatelist();
        this.save();
    }

    private void updatelist() {
        ArrayList<BagsDescription> list = new ArrayList<BagsDescription>();
        for (ItemStack stack : this.inventory) {
            if (stack == null || stack.m_41619_()) continue;
            if (list.isEmpty()) {
                list.add(new BagsDescription(stack));
                continue;
            }
            if (list.contains(new BagsDescription(stack))) {
                ((BagsDescription)list.get(list.indexOf(new BagsDescription(stack)))).addCount(stack.m_41613_());
                continue;
            }
            list.add(new BagsDescription(stack));
        }
        CompoundTag nbt = ModUtils.nbt(this.containerStack);
        CompoundTag nbt1 = new CompoundTag();
        nbt1.m_128405_("size", list.size());
        for (int i = 0; i < list.size(); ++i) {
            nbt1.m_128365_(String.valueOf(i), (Tag)((BagsDescription)list.get(i)).write(new CompoundTag()));
        }
        nbt.m_128365_("bag", (Tag)nbt1);
    }

    public void saveAndThrow(ItemStack stack) {
        ListTag contentList = new ListTag();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (ModUtils.isEmpty(this.inventory[i])) continue;
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_("Slot", (byte)i);
            this.inventory[i].m_41739_(nbt);
            contentList.add((Object)nbt);
        }
        ModUtils.nbt(stack).m_128365_("Items", (Tag)contentList);
        this.clear();
    }

    private boolean addWithoutSave(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            CompoundTag nbt = ModUtils.nbt(this.itemStack1);
            boolean white = nbt.m_128471_("white");
            for (ItemStack stack : stacks) {
                boolean can = false;
                if (white) {
                    for (ItemStack stack1 : this.list) {
                        if (stack1.m_41619_() || !ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack)) continue;
                        can = true;
                        break;
                    }
                } else {
                    for (ItemStack stack1 : this.list) {
                        if (!stack1.m_41619_() && ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack)) {
                            can = false;
                            break;
                        }
                        can = true;
                    }
                }
                if (!can) {
                    return false;
                }
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.get(i) == null || this.get(i).m_41619_()) {
                        if (!simulate) {
                            this.putWithoutSave(i, stack.m_41777_());
                            stack.m_41764_(0);
                        }
                        return true;
                    }
                    if (!this.get(i).m_150930_(stack.m_41720_()) || this.get(i).m_41613_() + stack.m_41613_() > stack.m_41741_()) continue;
                    if (stack.m_41783_() == null && this.get(i).m_41783_() == null) {
                        if (!simulate) {
                            this.get(i).m_41769_(stack.m_41613_());
                            stack.m_41764_(0);
                        }
                        return true;
                    }
                    if (stack.m_41783_() == null || !stack.m_41783_().equals((Object)this.get(i).m_41783_())) continue;
                    if (!simulate) {
                        this.get(i).m_41769_(stack.m_41613_());
                        stack.m_41764_(0);
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean addWithoutSave(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.addWithoutSave(Collections.singletonList(stack), false);
    }

    public void putWithoutSave(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
    }

    @Override
    public ItemStack m_7407_(int index, int amount) {
        ItemStack stack;
        if (index < this.inventory.length) {
            ItemStack stack2;
            if (index >= 0 && index < this.inventory.length && !ModUtils.isEmpty(stack2 = this.inventory[index])) {
                ItemStack ret;
                if (amount >= ModUtils.getSize(stack2)) {
                    ret = stack2;
                    this.inventory[index] = ModUtils.emptyStack;
                } else {
                    ret = ModUtils.setSize(stack2, amount);
                    this.inventory[index] = ModUtils.decSize(stack2, amount);
                }
                this.save();
                return ret;
            }
            return ModUtils.emptyStack;
        }
        if (index - this.inventory.length < this.list.length && !ModUtils.isEmpty(stack = this.list[index - this.inventory.length])) {
            ItemStack ret;
            if (amount >= ModUtils.getSize(stack)) {
                ret = stack;
                this.list[index - this.inventory.length] = ModUtils.emptyStack;
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.list[index - this.inventory.length] = ModUtils.decSize(stack, amount);
            }
            this.save();
            return ret;
        }
        return ModUtils.emptyStack;
    }

    @Override
    public void addInventorySlot(Inventory var1) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player var1, ContainerMenuBase<?> menu) {
        ContainerMenuBags containerLeadBox = (ContainerMenuBags)menu;
        return new ScreenBags(containerLeadBox, this.itemStack1);
    }

    public ContainerMenuBags getGuiContainer(Player player) {
        return new ContainerMenuBags(player, this);
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    @Override
    public boolean m_7013_(int p_18952_, ItemStack itemstack) {
        if (itemstack.m_41720_() instanceof ItemEnergyBags) {
            return false;
        }
        CompoundTag nbt = ModUtils.nbt(this.itemStack1);
        boolean white = nbt.m_128471_("white");
        boolean can = false;
        if (white) {
            for (ItemStack stack1 : this.list) {
                if (stack1.m_41619_() || !stack1.m_150930_(itemstack.m_41720_())) continue;
                can = true;
                break;
            }
        } else {
            for (ItemStack stack1 : this.list) {
                if (!stack1.m_41619_() && stack1.m_150930_(itemstack.m_41720_())) {
                    can = false;
                    break;
                }
                can = true;
            }
        }
        if (!can) {
            return false;
        }
        if (ElectricItem.manager.canUse(this.itemStack1, 50.0 * this.coef)) {
            return !itemstack.m_41619_();
        }
        return false;
    }

    protected void restore(ItemStack[] backup) {
        if (backup.length != this.inventory.length) {
            throw new IllegalArgumentException("invalid array size");
        }
        System.arraycopy(backup, 0, this.inventory, 0, this.inventory.length);
    }

    @Override
    @Nonnull
    public String getName() {
        return "toolbox";
    }

    public boolean hasCustomName() {
        return false;
    }

    public int add(Collection<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public boolean canAdd(Collection<ItemStack> stacks) {
        return this.add(stacks, true) == 0;
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    protected ItemStack[] backup() {
        ItemStack[] ret = new ItemStack[this.inventory.length];
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack content = this.inventory[i];
            ret[i] = ModUtils.isEmpty(content) ? ModUtils.emptyStack : content.m_41777_();
        }
        return ret;
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
        this.save();
    }

    public int getStackSizeLimit() {
        return 64;
    }

    private boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.get(i) == null || this.get(i).m_41619_()) {
                        if (!simulate) {
                            this.put(i, stack.m_41777_());
                        }
                        return true;
                    }
                    if (!this.get(i).m_150930_(stack.m_41720_()) || this.get(i).m_41613_() + stack.m_41613_() > stack.m_41741_()) continue;
                    if (stack.m_41783_() == null && this.get(i).m_41783_() == null) {
                        if (!simulate) {
                            this.get(i).m_41769_(stack.m_41613_());
                        }
                        return true;
                    }
                    if (stack.m_41783_() == null || !stack.m_41783_().equals((Object)this.get(i).m_41783_())) continue;
                    if (!simulate) {
                        this.get(i).m_41769_(stack.m_41613_());
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private int add(Collection<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            ItemStack[] backup = simulate ? this.backup() : null;
            int totalAmount = 0;
            Iterator<ItemStack> var5 = stacks.iterator();
            while (true) {
                if (!var5.hasNext()) {
                    if (simulate) {
                        this.restore(backup);
                    }
                    return totalAmount;
                }
                ItemStack stack = var5.next();
                int amount = ModUtils.getSize(stack);
                if (amount <= 0) continue;
                block1: for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < this.inventorySize; ++i) {
                        ItemStack existingStack = this.get(i);
                        int space = this.getStackSizeLimit();
                        if (!ModUtils.isEmpty(existingStack)) {
                            space = Math.min(space, existingStack.m_41741_()) - ModUtils.getSize(existingStack);
                        }
                        if (space <= 0) continue;
                        if (pass == 0 && !ModUtils.isEmpty(existingStack) && ModUtils.checkItemEqualityStrict(stack, existingStack)) {
                            if (space >= amount) {
                                existingStack.m_41769_(amount);
                                this.put(i, existingStack);
                                amount = 0;
                                break block1;
                            }
                            existingStack.m_41769_(space);
                            this.put(i, existingStack);
                            amount -= space;
                            continue;
                        }
                        if (pass != 1 || !ModUtils.isEmpty(existingStack)) continue;
                        if (space >= amount) {
                            this.put(i, ModUtils.setSize(stack, amount));
                            amount = 0;
                            break block1;
                        }
                        this.put(i, ModUtils.setSize(stack, space));
                        amount -= space;
                    }
                }
                totalAmount += amount;
            }
        }
        return 0;
    }
}

