/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.ItemFluidContainer;
import com.denfop.tabs.IItemTab;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSmallFluidCell
extends ItemFluidContainer
implements IItemTab {
    public ItemSmallFluidCell() {
        super(500);
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.fluidCellTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.addAll(this.getAllStacks());
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, list, tooltipFlag);
    }

    @Override
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, CompoundTag nbt) {
        return new CapabilityFluidHandlerItem(stack, 500){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && ItemSmallFluidCell.this.canfill(fluid.getFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return fluid != null && ItemSmallFluidCell.this.canfill(fluid.getFluid());
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
                if (resource == null) {
                    return 0;
                }
                return super.fill(resource, doFill);
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
                return super.drain(maxDrain, doDrain);
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
                if (resource == FluidStack.EMPTY) {
                    return FluidStack.EMPTY;
                }
                return super.drain(resource, doDrain);
            }

            @NotNull
            public ItemStack getContainer() {
                return this.getFluid() == FluidStack.EMPTY ? new ItemStack((ItemLike)this.container.m_41720_()) : this.container;
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }
}

