/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.roverassembler;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class RoverAssemblerHandler {
    private static final List<RoverAssemblerHandler> recipes = new ArrayList<RoverAssemblerHandler>();
    private final List<ItemStack> input;
    ItemStack output;

    public RoverAssemblerHandler(List<ItemStack> input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<RoverAssemblerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RoverAssemblerHandler.initRecipes();
        }
        return recipes;
    }

    public static RoverAssemblerHandler addRecipe(List<ItemStack> input, ItemStack output) {
        RoverAssemblerHandler recipe = new RoverAssemblerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("roverassembler")) {
            RoverAssemblerHandler.addRecipe(container.input.getStackInputs(), container.getOutput().items.get(0));
        }
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }
}

