/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.refrigeratorfluids;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class RefrigeratorFluidsHandler {
    private static final List<RefrigeratorFluidsHandler> recipes = new ArrayList<RefrigeratorFluidsHandler>();
    private final FluidStack input;
    private final FluidStack output;

    public RefrigeratorFluidsHandler(FluidStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<RefrigeratorFluidsHandler> getRecipes() {
        if (recipes.isEmpty()) {
            RefrigeratorFluidsHandler.initRecipes();
        }
        return recipes;
    }

    public static RefrigeratorFluidsHandler addRecipe(FluidStack input, FluidStack output) {
        RefrigeratorFluidsHandler recipe = new RefrigeratorFluidsHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe container : Recipes.recipes.getRecipeFluid().getRecipeList("refrigerator")) {
            RefrigeratorFluidsHandler.addRecipe(container.input.getInputs().get(0), container.getOutput_fluid().get(0));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

