/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.primal_laser;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class PrimalLaserHandler {
    private static final List<PrimalLaserHandler> recipes = new ArrayList<PrimalLaserHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public PrimalLaserHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<PrimalLaserHandler> getRecipes() {
        if (recipes.isEmpty()) {
            PrimalLaserHandler.initRecipes();
        }
        return recipes;
    }

    public static PrimalLaserHandler addRecipe(ItemStack input, ItemStack output) {
        PrimalLaserHandler recipe = new PrimalLaserHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static PrimalLaserHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (PrimalLaserHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("primal_laser_polisher")) {
            PrimalLaserHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

