/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.industrialorepurifier;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class IndustrialOrePurifierHandler {
    private static final List<IndustrialOrePurifierHandler> recipes = new ArrayList<IndustrialOrePurifierHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final int chance;

    public IndustrialOrePurifierHandler(ItemStack input, ItemStack output, int chance) {
        this.input = input;
        this.output = output;
        this.chance = chance;
    }

    public static List<IndustrialOrePurifierHandler> getRecipes() {
        if (recipes.isEmpty()) {
            IndustrialOrePurifierHandler.initRecipes();
        }
        return recipes;
    }

    public static IndustrialOrePurifierHandler addRecipe(ItemStack input, ItemStack output, int chance) {
        IndustrialOrePurifierHandler recipe = new IndustrialOrePurifierHandler(input, output, chance);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static IndustrialOrePurifierHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (IndustrialOrePurifierHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("ore_purifier")) {
            IndustrialOrePurifierHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.m_128451_("se"));
        }
    }

    public int getChance() {
        return this.chance;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

