/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.fluidmixer;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FluidMixerHandler {
    private static final List<FluidMixerHandler> recipes = new ArrayList<FluidMixerHandler>();
    private final FluidStack output1;
    private final FluidStack input;
    private final FluidStack output;
    private final FluidStack output2;

    public FluidMixerHandler(FluidStack input, FluidStack output, FluidStack output1, FluidStack output2) {
        this.input = input;
        this.output1 = output1;
        this.output = output;
        this.output2 = output2;
    }

    public static List<FluidMixerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            FluidMixerHandler.initRecipes();
        }
        return recipes;
    }

    public static FluidMixerHandler addRecipe(FluidStack input, FluidStack output, FluidStack output1, FluidStack output2) {
        FluidMixerHandler recipe = new FluidMixerHandler(input, output, output1, output2);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static FluidMixerHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        return recipes.get(0);
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe machineRecipe : Recipes.recipes.getRecipeFluid().getRecipeList("fluid_mixer")) {
            FluidStack fluidStack = machineRecipe.getInput().getInputs().get(0);
            FluidStack fluidStack1 = machineRecipe.getInput().getInputs().get(1);
            FluidStack fluidStack2 = machineRecipe.getOutput_fluid().get(0);
            FluidStack fluidStack3 = machineRecipe.getOutput_fluid().get(1);
            FluidMixerHandler.addRecipe(fluidStack, fluidStack1, fluidStack2, fluidStack3);
        }
    }

    public FluidStack getOutput2() {
        return this.output2;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public FluidStack getOutput1() {
        return this.output1;
    }
}

