/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.farmer;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class FarmerHandler {
    private static final List<FarmerHandler> recipes = new ArrayList<FarmerHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public FarmerHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<FarmerHandler> getRecipes() {
        if (recipes.isEmpty()) {
            FarmerHandler.initRecipes();
        }
        return recipes;
    }

    public static FarmerHandler addRecipe(ItemStack input, ItemStack output) {
        FarmerHandler recipe = new FarmerHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static FarmerHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (FarmerHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("farmer")) {
            FarmerHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return is.m_41720_() == this.input.m_41720_();
    }
}

