/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.enchanter;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class EnchantHandler {
    private static final List<EnchantHandler> recipes = new ArrayList<EnchantHandler>();
    private final ItemStack input;
    private final ItemStack input1;
    private final ItemStack output;

    public EnchantHandler(ItemStack input, ItemStack input1, ItemStack output) {
        this.input = input;
        this.input1 = input1;
        this.output = output;
    }

    public static List<EnchantHandler> getRecipes() {
        if (recipes.isEmpty()) {
            EnchantHandler.initRecipes();
        }
        return recipes;
    }

    public static EnchantHandler addRecipe(ItemStack input, ItemStack input1, ItemStack output) {
        EnchantHandler recipe = new EnchantHandler(input, input1, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static EnchantHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (EnchantHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("enchanter_books")) {
            EnchantHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.input.getInputs().get(1).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput1() {
        return this.input1;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public List<ItemStack> getInputs() {
        return Arrays.asList(this.input, this.input1);
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

