/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.convertermatter;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class ConverterHandler {
    private static final List<ConverterHandler> recipes = new ArrayList<ConverterHandler>();
    private final ItemStack output;

    public ConverterHandler(ItemStack output) {
        this.output = output;
    }

    public static List<ConverterHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ConverterHandler.initRecipes();
        }
        return recipes;
    }

    public static ConverterHandler addRecipe(ItemStack output) {
        ConverterHandler recipe = new ConverterHandler(output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static ConverterHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        Iterator<ConverterHandler> iterator = recipes.iterator();
        if (iterator.hasNext()) {
            ConverterHandler recipe = iterator.next();
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("converter")) {
            ConverterHandler.addRecipe(container.getOutput().items.get(0));
        }
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }
}

