/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.combmac;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class CombMacHandler {
    private static final List<CombMacHandler> recipes = new ArrayList<CombMacHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final BaseMachineRecipe container;

    public CombMacHandler(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        this.input = input;
        this.output = output;
        this.output.m_41764_(3);
        this.container = container;
    }

    public static List<CombMacHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CombMacHandler.initRecipes();
        }
        return recipes;
    }

    public static CombMacHandler addRecipe(ItemStack input, ItemStack output, BaseMachineRecipe container) {
        CombMacHandler recipe = new CombMacHandler(input, output, container);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CombMacHandler getRecipe(ItemStack is) {
        if (is == null || is.m_41619_()) {
            return null;
        }
        for (CombMacHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("comb_macerator")) {
            CombMacHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container);
        }
    }

    public BaseMachineRecipe getContainer() {
        return this.container;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public boolean matchesInput(ItemStack is) {
        return is.m_41720_() == this.input.m_41720_();
    }
}

