/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.dataregistry;

import com.denfop.dataregistry.DataItem;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class DataSimpleItem<E extends Item, T extends ResourceLocation> {
    RegistryObject<E> registryObject;

    public DataSimpleItem(T typeClass, Supplier<E> supplier) {
        this(typeClass, supplier, "industrialupgrade", Register.ITEMS);
    }

    public DataSimpleItem(T resource, Supplier<E> supplier, String constants, DeferredRegister<Item> ITEMS) {
        String namespace = resource.m_135827_().isEmpty() ? "" : resource.m_135827_() + "/";
        ResourceLocation key = new ResourceLocation(constants, namespace + resource.m_135815_());
        RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)ITEMS.getRegistryKey(), (String)constants);
        Map entries = ((DeferredRegisterAccessor)ITEMS).getEntries();
        DataItem.objects.add((RegistryObject<Item>)ret);
        if (entries.putIfAbsent(ret, supplier) != null) {
            throw new IllegalArgumentException("Duplicate registration " + resource);
        }
        this.registryObject = ret;
    }

    public RegistryObject<E> getRegistryObject() {
        return this.registryObject;
    }

    public ItemStack getItemStack() {
        return new ItemStack((ItemLike)this.registryObject.get());
    }

    public ItemStack getItem(int count) {
        return new ItemStack((ItemLike)this.registryObject.get(), count);
    }

    public E getItem() {
        return (E)((Item)this.registryObject.get());
    }
}

