/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.dataregistry;

import com.denfop.blocks.SubEnum;
import com.denfop.mixin.access.DeferredRegisterAccessor;
import com.denfop.register.Register;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

public class DataItem<T extends Enum<T>, E extends Item> {
    public static List<RegistryObject<Item>> objects = new LinkedList<RegistryObject<Item>>();
    List<RegistryObject<E>> registryObjectList;

    public DataItem(Class<T> typeClass, Class<E> itemClass) {
        this(typeClass, itemClass, "industrialupgrade");
    }

    public DataItem(Class<T> typeClass, Class<E> itemClass, String constants) {
        HashMap<Enum, RegistryObject> map = new HashMap<Enum, RegistryObject>();
        Enum[] collections = (Enum[])typeClass.getEnumConstants();
        int indexMax = 0;
        for (Enum type : collections) {
            try {
                if (!Item.class.isAssignableFrom(itemClass)) {
                    throw new IllegalArgumentException("E must extend net.minecraft.world.item.Item");
                }
                Constructor<?> constructor = itemClass.getConstructors()[0];
                Supplier<Item> supplier = () -> {
                    try {
                        return (Item)constructor.newInstance(type);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
                ResourceLocation key = new ResourceLocation(constants, ((SubEnum)((Object)type)).getMainPath() + "/" + ((SubEnum)((Object)type)).m_7912_() + ((SubEnum)((Object)type)).getOtherPart());
                if (indexMax < ((SubEnum)((Object)type)).getId()) {
                    indexMax = ((SubEnum)((Object)type)).getId();
                }
                if (!((SubEnum)((Object)type)).register()) continue;
                RegistryObject ret = RegistryObject.create((ResourceLocation)key, (ResourceKey)Register.ITEMS.getRegistryKey(), (String)constants);
                objects.add((RegistryObject<Item>)ret);
                Map entries = ((DeferredRegisterAccessor)Register.ITEMS).getEntries();
                if (entries.putIfAbsent(ret, supplier) != null) {
                    throw new IllegalArgumentException("Duplicate registration " + type);
                }
                map.put(type, ret);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.registryObjectList = new ArrayList<Object>(Collections.nCopies(indexMax + 1, null));
        for (Map.Entry entry : map.entrySet()) {
            this.registryObjectList.set(((SubEnum)((Object)((Enum)entry.getKey()))).getId(), (RegistryObject)entry.getValue());
        }
    }

    public E getStack(T meta) {
        return (E)((Item)this.registryObjectList.get(((SubEnum)meta).getId()).get());
    }

    public E getStack(int meta) {
        return (E)((Item)this.registryObjectList.get(meta % this.registryObjectList.size()).get());
    }

    public ItemStack getItemStack(int meta) {
        return new ItemStack((ItemLike)this.registryObjectList.get(meta % this.registryObjectList.size()).get());
    }

    public ItemStack getItemStack(int meta, int col) {
        return new ItemStack((ItemLike)this.registryObjectList.get(meta % this.registryObjectList.size()).get(), col);
    }

    public E getItemFromMeta(int meta) {
        return (E)((Item)this.registryObjectList.get(meta % this.registryObjectList.size()).get());
    }

    public RegistryObject<E> getRegistryObject(int meta) {
        return this.registryObjectList.get(meta % this.registryObjectList.size());
    }

    public int getMeta(E item) {
        int i = 0;
        for (RegistryObject<E> registryObject : this.registryObjectList) {
            if (registryObject.get() == item) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getMeta(ItemStack itemStack) {
        int i = 0;
        Item item = itemStack.m_41720_();
        for (RegistryObject<E> registryObject : this.registryObjectList) {
            if (((Item)registryObject.get()).equals(item)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public E getItem(T meta) {
        return (E)((Item)this.registryObjectList.get(((SubEnum)meta).getId()).get());
    }
}

