/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets.heat;

import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.heat.IHeatAcceptor;
import com.denfop.api.otherenergies.heat.IHeatEmitter;
import com.denfop.api.otherenergies.heat.IHeatTile;
import com.denfop.componets.BufferEnergy;
import com.denfop.componets.HeatComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyNetDelegate
implements IHeatTile {
    public final BufferEnergy buffer;
    public final BlockPos worldPosition;
    private final boolean clientSide;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public double tick;
    public Map<Direction, IHeatTile> energyConductorMap = new HashMap<Direction, IHeatTile>();
    public int hashCodeSource;
    protected double pastEnergy;
    protected double perenergy;
    List<InfoTile<IHeatTile>> validReceivers = new LinkedList<InfoTile<IHeatTile>>();
    private long id;

    public EnergyNetDelegate(HeatComponent block) {
        this.worldPosition = block.getParent().pos;
        this.clientSide = block.getParent().m_58904_().f_46443_;
        this.sinkDirections = block.sinkDirections;
        this.sourceDirections = block.sourceDirections;
        this.buffer = block.buffer;
    }

    @Override
    public BlockPos getPos() {
        return this.worldPosition;
    }

    @Override
    public BlockEntity getTile() {
        return null;
    }

    public boolean acceptsHeatFrom(IHeatEmitter var1, Direction var2) {
        for (Direction facing1 : this.sinkDirections) {
            if (facing1.ordinal() != var2.ordinal()) continue;
            return true;
        }
        return false;
    }

    public boolean emitHeatTo(IHeatAcceptor receiver, Direction dir) {
        return this.sourceDirections.contains(dir);
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddHeatTile(IHeatTile tile, Direction facing1) {
        if (!this.clientSide && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IHeatTile>(tile, facing1.m_122424_()));
        }
    }

    @Override
    public void RemoveHeatTile(IHeatTile tile, Direction facing1) {
        if (!this.clientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IHeatTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IHeatTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public Map<Direction, IHeatTile> getHeatTiles() {
        return this.energyConductorMap;
    }

    public void setSinkDirections(Set<Direction> sinkDirections) {
        this.sinkDirections = sinkDirections;
    }

    public void setSourceDirections(Set<Direction> sourceDirections) {
        this.sourceDirections = sourceDirections;
    }

    public double getSourceEnergy() {
        return this.buffer.storage;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public List<InfoTile<IHeatTile>> getHeatValidReceivers() {
        return this.validReceivers;
    }
}

