/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.TypePurifierJob;
import com.denfop.componets.TypeUpgrade;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ComponentUpgrade
extends AbstractComponent {
    private final List<TypeUpgrade> listUpgrade;
    private final List<TypeUpgrade> listActiveUpgrade = new ArrayList<TypeUpgrade>();
    private boolean change = true;

    public ComponentUpgrade(BlockEntityInventory parent, TypeUpgrade ... typeUpgrades) {
        super(parent);
        this.listUpgrade = Arrays.asList(typeUpgrades);
    }

    public boolean isChange() {
        return this.change;
    }

    public void setChange(boolean change) {
        this.change = change;
    }

    public boolean hasUpgrade(TypeUpgrade typeUpgrade) {
        return this.listActiveUpgrade.contains((Object)typeUpgrade);
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return !this.listActiveUpgrade.isEmpty();
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> list = super.getDrops();
        for (TypeUpgrade upgrade : this.listActiveUpgrade) {
            list.add(upgrade.getStack().m_41777_());
        }
        return list;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        TypeUpgrade type = this.listActiveUpgrade.remove(0);
        this.change = true;
        if (type != null) {
            return type.getStack().m_41777_();
        }
        return super.getItemStackUpgrade();
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        for (TypeUpgrade upgrade : this.listUpgrade) {
            if (upgrade.getStack().m_41720_() != stack.m_41720_() || this.listActiveUpgrade.contains((Object)upgrade)) continue;
            this.listActiveUpgrade.add(upgrade);
            stack.m_41774_(1);
            this.change = true;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag nbt = super.writeToNbt();
        nbt.m_128405_("max", this.listActiveUpgrade.size());
        int i = 0;
        for (TypeUpgrade upgrade : this.listActiveUpgrade) {
            nbt.m_128405_(String.valueOf(i), upgrade.ordinal());
            ++i;
        }
        return nbt;
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer();
        buffer.writeInt(this.listActiveUpgrade.size());
        for (TypeUpgrade upgrade : this.listActiveUpgrade) {
            buffer.writeInt(upgrade.ordinal());
        }
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        int i = is.readInt();
        for (int j = 0; j < i; ++j) {
            this.listActiveUpgrade.add(TypeUpgrade.values()[is.readInt()]);
        }
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        int size = nbt.m_128451_("max");
        TypeUpgrade[] values = TypeUpgrade.values();
        for (int i = 0; i < size; ++i) {
            this.listActiveUpgrade.add(values[nbt.m_128451_(String.valueOf(i))]);
        }
    }
}

