/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.IMultiUpdateTick;
import com.denfop.api.recipe.InventoryBioMultiRecipes;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.sound.EnumTypeAudio;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.EnumMultiMachine;
import com.denfop.blockentity.base.IBioMachine;
import com.denfop.blockentity.mechanism.EnumTypeMachines;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentBioFuelEnergy;
import com.denfop.componets.HeatComponent;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BioProcessMultiComponent
extends AbstractComponent
implements IMultiUpdateTick {
    public final InventoryBioMultiRecipes inputSlots;
    public final InventoryOutput outputSlot;
    public final HeatComponent heat;
    public final boolean isCentrifuge;
    private final ComponentBioFuelEnergy bioFuel;
    private final IBioMachine multimachine;
    private final EnumMultiMachine enumMultiMachine;
    private final int sizeWorkingSlot;
    private final short[] progress;
    private final double[] guiProgress;
    private final double defaultEnergyConsume;
    private final int defaultOperationLength;
    private final int operationChange;
    private final MachineRecipe[] output;
    public double energyConsume;
    public int operationLength;
    private int mode;
    private int[] col;

    public BioProcessMultiComponent(IBioMachine parent, EnumMultiMachine enumMultiMachine) {
        super((BlockEntityBase)((Object)parent));
        this.multimachine = parent;
        this.inputSlots = new InventoryBioMultiRecipes((BlockEntityInventory)((Object)parent), enumMultiMachine.type.recipe, (IMultiUpdateTick)this, enumMultiMachine.sizeWorkingSlot, this);
        this.outputSlot = new InventoryOutput((CustomWorldContainer)((Object)parent), enumMultiMachine.sizeWorkingSlot + (enumMultiMachine.output ? 2 : 0));
        this.enumMultiMachine = enumMultiMachine;
        this.sizeWorkingSlot = enumMultiMachine.sizeWorkingSlot;
        this.progress = new short[this.sizeWorkingSlot];
        this.guiProgress = new double[this.sizeWorkingSlot];
        double coefenergy = 1.0;
        double speed = 1.0;
        this.mode = 0;
        this.defaultEnergyConsume = this.energyConsume = (double)Math.max((int)((double)enumMultiMachine.usagePerTick * coefenergy), 1) / 2.0;
        this.operationChange = this.operationLength = Math.max((int)((double)enumMultiMachine.lenghtOperation * 1.0 / speed), 1);
        this.defaultOperationLength = this.operationLength;
        this.output = new MachineRecipe[this.sizeWorkingSlot];
        this.bioFuel = ((BlockEntityBase)((Object)parent)).getComp(ComponentBioFuelEnergy.class);
        this.heat = ((BlockEntityBase)((Object)parent)).getComp(HeatComponent.class);
        this.isCentrifuge = enumMultiMachine.type == EnumTypeMachines.Centrifuge;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.parent.getActive() && this.parent.getWorld().m_46467_() % 4L == 0L) {
            double x = (double)this.parent.m_58899_().m_123341_() + 0.5;
            double y = (double)this.parent.m_58899_().m_123342_() + 1.1;
            double z = (double)this.parent.m_58899_().m_123343_() + 0.5;
            this.parent.m_58904_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_()), x, y, z, 0.0, 0.1, 0.0);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.parent.m_58904_().f_46443_) {
            this.inputSlots.load();
            this.getsOutputs();
        }
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        return false;
    }

    public void setOverclockRates() {
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeInt(this.operationLength);
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            buffer.writeInt(this.progress[i]);
        }
        buffer.writeDouble(this.energyConsume);
        buffer.writeInt(this.mode);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeInt(this.operationLength);
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            buffer.writeInt(this.progress[i]);
        }
        buffer.writeDouble(this.energyConsume);
        buffer.writeInt(this.mode);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        this.operationLength = is.readInt();
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            this.progress[i] = (short)is.readInt();
        }
        this.energyConsume = is.readDouble();
        this.mode = is.readInt();
    }

    @Override
    public void updateEntityServer() {
        boolean active = false;
        int type = -1;
        for (int i = 0; i < this.getSizeWorkingSlot(); ++i) {
            MachineRecipe output = this.output[i];
            boolean size = true;
            if (output != null && this.inputSlots.continue_proccess(this.outputSlot, i) && this.bioFuel.canUseEnergy(this.energyConsume)) {
                active = true;
                if (this.multimachine.getTank() != null && (this.multimachine.getTank().getFluid().isEmpty() || this.multimachine.getTank().getFluid().getAmount() < 1000)) {
                    return;
                }
                if (this.multimachine.getHeat() != null) {
                    if (output.getRecipe().output.metadata.m_128448_("minHeat") == 0 || (double)output.getRecipe().output.metadata.m_128448_("minHeat") > this.heat.getEnergy()) {
                        if (!this.heat.buffer.need) {
                            this.heat.buffer.need = true;
                        }
                        return;
                    }
                    if (this.heat.buffer.need) {
                        this.heat.buffer.need = false;
                    }
                }
                if (this.progress[i] == 0 && (double)this.operationLength > (double)this.defaultOperationLength * 0.1 && type == -1) {
                    this.multimachine.initiate(0);
                    type = 0;
                }
                this.bioFuel.useEnergy(this.energyConsume);
                int n = i;
                this.progress[n] = (short)(this.progress[n] + 1);
                this.guiProgress[i] = (double)this.progress[i] / (double)this.operationLength;
                if (this.progress[i] < this.operationLength) continue;
                this.guiProgress[i] = 0.0;
                this.progress[i] = 0;
                this.operate(i, output);
                if (!((double)this.operationLength > (double)this.defaultOperationLength * 0.1) && this.multimachine.getTypeAudio() == EnumTypeAudio.VALUES[2 % EnumTypeAudio.VALUES.length] || type != -1) continue;
                this.multimachine.initiate(2);
                type = 2;
                continue;
            }
            if (this.progress[i] != 0 && this.parent.getActive() && ((double)this.operationLength > (double)this.defaultOperationLength * 0.1 || this.multimachine.getTypeAudio() != EnumTypeAudio.VALUES[1 % EnumTypeAudio.VALUES.length]) && type == -1) {
                this.multimachine.initiate(1);
                type = 1;
            }
            if (output != null) continue;
            this.progress[i] = 0;
        }
        if (this.multimachine.getHeat() != null) {
            this.multimachine.getHeat().useEnergy(1.0);
        }
        if (this.parent.getActive() != active) {
            this.parent.setActive(active);
        }
    }

    @Override
    public MachineRecipe getRecipeOutput(int slotId) {
        return this.output[slotId];
    }

    @Override
    public void setRecipeOutput(MachineRecipe output, int slotId) {
        this.output[slotId] = output;
    }

    public int getSizeWorkingSlot() {
        return this.sizeWorkingSlot;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output[0];
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output[0] = output;
    }

    private void getsOutputs() {
        for (int i = 0; i < this.sizeWorkingSlot; ++i) {
            this.output[i] = this.getOutput(i);
        }
    }

    public void operate(int slotId, MachineRecipe output) {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce(slotId, output.getRecipe().output.items);
            if (this.multimachine.getTank() != null) {
                this.multimachine.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.enumMultiMachine.recipe.equals("recycler")) continue;
            if (this.multimachine.getTank() != null && (this.multimachine.getTank().getFluid().isEmpty() || this.multimachine.getTank().getFluid().getAmount() < 1000)) break;
            if (this.inputSlots.get(slotId).m_41619_() || this.inputSlots.get(slotId).m_41613_() < this.output[slotId].getRecipe().input.getInputs().get(0).getAmount() || !this.outputSlot.canAdd(output.getRecipe().output.items)) {
                this.getOutput(slotId);
                break;
            }
            if (!this.inputSlots.get(slotId).m_41619_() && this.inputSlots.get(slotId).m_41613_() >= 1 && this.outputSlot.canAdd(output.getRecipe().output.items)) continue;
            this.getOutput(slotId);
            break;
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public void operateOnce(int slotId, List<ItemStack> processResult) {
        for (ItemStack stack : processResult) {
            this.outputSlot.add(stack);
        }
        this.inputSlots.consume(slotId);
    }

    public MachineRecipe getOutput(int slotId) {
        if (this.enumMultiMachine == null || this.enumMultiMachine.type != EnumTypeMachines.COMBRECYCLER && this.enumMultiMachine.type != EnumTypeMachines.RECYCLER) {
            if (this.inputSlots.get(slotId).m_41619_()) {
                this.output[slotId] = null;
                return null;
            }
            this.output[slotId] = this.inputSlots.process(slotId);
            return this.output[slotId];
        }
        if (this.inputSlots.get(slotId).m_41619_()) {
            this.output[slotId] = null;
            return null;
        }
        this.output[slotId] = this.inputSlots.recycler_output;
        return this.output[slotId];
    }

    public double getProgress(int slotId) {
        return (double)this.progress[slotId] * 1.0 / (double)this.operationLength;
    }
}

