/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.storage;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.storage.EnumTypeSlots;
import com.denfop.api.storage.IWorkbenchInterface;
import com.denfop.api.storage.Interface;
import com.denfop.api.storage.PatternItem;
import com.denfop.api.storage.StorageNetwork;
import com.denfop.api.storage.autocrafting.PatternStack;
import com.denfop.api.storage.autocrafting.TypeRecipe;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockStorageSystemEntity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.containermenu.ContainerInterface;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenInterface;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class BlockEntityInterface
extends BlockEntityInventory
implements IWorkbenchInterface {
    private final Inventory slotSlots;
    Map<Integer, PatternStack> patternItemHashMap = new HashMap<Integer, PatternStack>();
    List<PatternStack> patternStacks = new LinkedList<PatternStack>();
    protected ComponentBaseEnergy energy = this.addComponent(ComponentBaseEnergy.asBasicSink(EnergyType.STORAGE, this, 0.0));
    private StorageNetwork network;
    BlockEntity blockEntityDown;

    public BlockEntityInterface(BlockPos pos, BlockState state) {
        super(BlockStorageSystemEntity.interface_workbench, pos, state);
        this.slotSlots = new Inventory(this, Inventory.TypeItemSlot.INPUT, 36){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() instanceof PatternItem && ((PatternItem)stack.m_41720_()).hasPattern(stack) && ((PatternItem)stack.m_41720_()).getPattern(stack).typeRecipe() == TypeRecipe.BLOCK;
            }

            @Override
            public ItemStack set(int i, ItemStack empty) {
                ItemStack stack = super.set(i, empty);
                BlockEntityInterface.this.reload();
                if (BlockEntityInterface.this.network != null) {
                    StorageNetwork storageNetwork = BlockEntityInterface.this.network;
                    storageNetwork.reloadInterface((Interface)((Object)this.base));
                }
                return stack;
            }
        };
        this.slotSlots.setStackSizeLimit(1);
    }

    public void reload() {
        this.patternItemHashMap.clear();
        this.patternStacks.clear();
        for (int i = 0; i < this.slotSlots.size(); ++i) {
            ItemStack stack = this.slotSlots.m_8020_(i);
            if (stack.m_41619_()) continue;
            PatternItem cellItem = (PatternItem)stack.m_41720_();
            PatternStack cell = cellItem.getPattern(stack);
            this.patternItemHashMap.put(i, cell);
            this.patternStacks.add(cell);
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockStorageSystemEntity.interface_entity;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.storageSystem.getBlock(this.getTeBlock());
    }

    public Inventory getSlots() {
        return this.slotSlots;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    public ContainerInterface getGuiContainer(Player var1) {
        return new ContainerInterface(this, var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player var1, ContainerMenuBase<?> var2) {
        return new ScreenInterface((ContainerInterface)var2);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> itemStackList = super.getWrenchDrops(player, fortune);
        return itemStackList;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.pos.m_121955_(Direction.DOWN.m_122436_()).equals((Object)neighborPos)) {
            this.blockEntityDown = this.m_58904_().m_7702_(neighborPos);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.blockEntityDown = this.m_58904_().m_7702_(this.pos.m_121955_(Direction.DOWN.m_122436_()));
        for (int i = 0; i < this.slotSlots.size(); ++i) {
            ItemStack stack = this.slotSlots.m_8020_(i);
            if (stack.m_41619_()) {
                PatternStack cell = this.patternItemHashMap.remove(i);
                this.patternStacks.remove(cell);
                continue;
            }
            PatternItem cellItem = (PatternItem)stack.m_41720_();
            PatternStack cell = cellItem.getPattern(stack);
            if (!this.patternItemHashMap.containsKey(i)) {
                this.patternItemHashMap.put(i, cell);
            } else {
                PatternStack cell1 = this.patternItemHashMap.remove(i);
                this.patternItemHashMap.put(i, cell);
                this.patternStacks.remove(cell1);
            }
            this.patternStacks.add(cell);
        }
    }

    @Override
    public double getRequiredPower() {
        return 1.0;
    }

    @Override
    public void setStorageNetwork(StorageNetwork network) {
        this.network = network;
    }

    @Override
    public List<PatternStack> getPatterns() {
        return this.patternStacks;
    }

    @Override
    public List<ItemStack> getStacks() {
        return Collections.emptyList();
    }

    @Override
    public List<FluidStack> getFluidStacks() {
        return Collections.emptyList();
    }

    @Override
    public Direction getDirection() {
        return Direction.DOWN;
    }

    @Override
    public BlockEntity getBlockEntityNeighbor() {
        return this.blockEntityDown;
    }

    @Override
    public EnumTypeSlots getTypeSlots() {
        return EnumTypeSlots.WHITELIST;
    }
}

