/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.reactors.graphite.tank;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.reactors.graphite.ITank;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuGraphiteTank;
import com.denfop.screen.ScreenGraphiteMainTank;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityMainTank
extends BlockEntityMultiBlockElement
implements ITank {
    public final Fluids fluids = this.addComponent(new Fluids(this));
    public final Fluids.InternalFluidTank tank;

    public BlockEntityMainTank(int col, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.tank = this.fluids.addTank("fluidTank", col);
        this.tank.setCanAccept(false);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.tank.setCanAccept(this.getMain() != null && this.getMain().isFull());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenGraphiteMainTank((ContainerMenuGraphiteTank)menu);
    }

    public ContainerMenuGraphiteTank getGuiContainer(Player var1) {
        return new ContainerMenuGraphiteTank(this, var1);
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.hasFluidHandler(player.m_21120_(hand)) && this.getMain() != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public Fluids getFluids() {
        return this.fluids;
    }

    @Override
    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    @Override
    public void setFluid(Fluid fluid) {
        this.tank.setAcceptedFluids(Fluids.fluidPredicate(fluid));
    }
}

