/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steamboiler;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.mechanism.steamboiler.ITank;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockSteamBoilerEntity;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BlockEntitySteamTankBoiler
extends BlockEntityMultiBlockElement
implements ITank {
    private final Fluids fluids = this.addComponent(new Fluids(this));
    private final Fluids.InternalFluidTank tank = this.fluids.addTank("tank", 4000);
    private ComponentSteamEnergy steam = this.addComponent(ComponentSteamEnergy.asBasicSource(this, 4000.0));
    private int amount;

    public BlockEntitySteamTankBoiler(BlockPos pos, BlockState state) {
        super(BlockSteamBoilerEntity.steam_boiler_tank, pos, state);
        this.steam.setFluidTank(this.tank);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                this.tank.setFluid(((FluidTank)DecoderHandler.decode(is)).getFluid());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.tank.setFluid(((FluidTank)DecoderHandler.decode(customPacketBuffer)).getFluid());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, (Object)this.tank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            new PacketUpdateFieldTile(this, "fluidTank", (Object)this.tank);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.amount != this.tank.getFluidAmount()) {
            this.amount = this.tank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidTank", (Object)this.tank);
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().f_46443_ && FluidHandlerFix.getFluidHandler(player.m_21120_(hand)) != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(ForgeCapabilities.FLUID_HANDLER, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    @Override
    public void setSteam() {
        this.tank.setTypeItemSlot(Inventory.TypeItemSlot.NONE);
        this.steam.onLoaded();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockSteamBoilerEntity.steam_boiler_tank;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.steam_boiler.getBlock(this.getTeBlock());
    }

    @Override
    public ComponentSteamEnergy getSteam() {
        return this.steam;
    }

    @Override
    public void setUnloaded() {
        this.steam.onUnloaded();
    }

    @Override
    public void setMainMultiElement(IMainMultiBlock main) {
        super.setMainMultiElement(main);
        if (main == null && this.steam != null) {
            this.steam.onUnloaded();
        }
    }
}

