/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.quantum_storage;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockResource;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuQuantumStorage;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenQuantumStorage;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityQuantumStorage
extends BlockEntityInventory
implements IType {
    public final ComponentBaseEnergy qe;
    private final EnumTypeStyle enumTypeStyle;

    public BlockEntityQuantumStorage(double maxStorage1, EnumTypeStyle enumTypeStyle, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.qe = this.addComponent(new ComponentBaseEnergy(EnergyType.QUANTUM, (BlockEntityInventory)this, maxStorage1, Arrays.stream(Direction.values()).filter(f -> f != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()), EnergyNetGlobal.instance.getTierFromPower(14.0), EnergyNetGlobal.instance.getTierFromPower(14.0)));
        this.enumTypeStyle = enumTypeStyle;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.m_58904_().f_46443_) {
            this.qe.setDirections(new HashSet<Direction>(Arrays.stream(Direction.values()).filter(facing1 -> facing1 != Direction.UP && facing1 != this.getFacing()).collect(Collectors.toList())), new HashSet<Direction>(Collections.singletonList(this.getFacing())));
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        CompoundTag nbt = ModUtils.nbt(stack);
        double energy1 = nbt.m_128459_("energy");
        tooltip.add(Localization.translate("iu.item.tooltip.Capacity") + " " + ModUtils.getString(this.qe.getCapacity()) + " QE");
        if (energy1 != 0.0) {
            tooltip.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(energy1) + "/" + ModUtils.getString(this.qe.getCapacity()) + " QE");
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    ComponentBaseEnergy component2 = this.qe;
                    if (component2 != null && component2.getEnergy() != 0.0) {
                        CompoundTag nbt = ModUtils.nbt(drop);
                        nbt.m_128347_("energy", component2.getEnergy());
                    }
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack(IUItem.basemachine2.getItem(78), 1);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        ComponentBaseEnergy component2 = this.qe;
        if (component2 != null && component2.getEnergy() != 0.0) {
            CompoundTag nbt = ModUtils.nbt(drop);
            nbt.m_128347_("energy", component2.getEnergy());
        }
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        CompoundTag nbt = ModUtils.nbt(stack);
        double energy1 = nbt.m_128459_("energy");
        if (energy1 != 0.0) {
            this.qe.addEnergy(energy1);
        }
    }

    public ContainerMenuQuantumStorage getGuiContainer(Player entityPlayer) {
        return new ContainerMenuQuantumStorage(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> b) {
        return new ScreenQuantumStorage((ContainerMenuQuantumStorage)b);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return this.enumTypeStyle;
    }
}

