/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.generator.energy;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuPeatGenerator;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenPeatGenerator;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityPeatGenerator
extends BlockEntityElectricMachine
implements IType {
    public final Inventory slot;
    public int fuel = 0;

    public BlockEntityPeatGenerator(BlockPos pos, BlockState state) {
        super(0.0, 1, 0, BlockBaseMachine3Entity.peat_generator, pos, state);
        this.energy = this.addComponent(Energy.asBasicSource(this, 150000.0, 1));
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                return stack.m_41720_() == IUItem.cultivated_peat_balls.getItem();
            }
        };
        this.addComponent(new SoilPollutionComponent(this, 0.2));
        this.addComponent(new AirPollutionComponent(this, 0.2));
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.getActive()) {
            ModUtils.showFlames(this.getWorld(), this.pos, this.getFacing());
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.fuel = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.peat_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fuel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.slot.m_7983_() && this.fuel == 0) {
            this.fuel = 400;
            this.slot.get(0).m_41774_(1);
            if (!this.getActive()) {
                this.setActive(true);
            }
        }
        if (this.fuel == 0 && this.getActive()) {
            this.setActive(false);
        }
        if (this.getActive()) {
            this.energy.addEnergy(25.0);
            this.fuel = Math.max(0, this.fuel - 1);
        }
    }

    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return (int)Math.min((double)(this.fuel * i) / 400.0, (double)i);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.fuel = nbttagcompound.m_128451_("fuel");
    }

    public int gaugeStorageScaled(int i) {
        return (int)(this.energy.getEnergy() * (double)i / this.energy.getCapacity());
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128405_("fuel", this.fuel);
        return nbt;
    }

    public ContainerMenuPeatGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerMenuPeatGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenPeatGenerator((ContainerMenuPeatGenerator)menu);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return EnumTypeStyle.DEFAULT;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

