/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuWaterRotorAssembler;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenWaterRotorAssembler;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityWaterRotorAssembler
extends BlockEntityInventory
implements IUpdateTick,
IHasRecipe {
    public final InventoryRecipes inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "water_rotor_assembler", (IUpdateTick)this);
    public final Energy energy;
    public final int defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final int defaultEnergyStorage;
    public final InventoryOutput outputSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public MachineRecipe recipe;
    public short progress;
    public double guiProgress;
    public int energyConsume;
    public int operationLength;
    public int operationsPerTick = 1;

    public BlockEntityWaterRotorAssembler(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.water_rotor_assembler, pos, state);
        this.inputSlotA.setStackSizeLimit(1);
        this.energyConsume = 2;
        this.defaultEnergyConsume = 2;
        this.operationLength = 100;
        this.defaultOperationLength = 100;
        this.defaultTier = 14;
        this.defaultEnergyStorage = 200;
        this.recipe = null;
        this.outputSlot = new InventoryOutput(this, 1);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, (double)this.defaultEnergyStorage, this.defaultTier));
        Recipes.recipes.addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.05));
    }

    public static void addRecipe(int meta, int meta1, ItemStack stack) {
        IInputHandler input = Recipes.inputFactory;
        ((ItemDamage)stack.m_41720_()).setCustomDamage(stack, 0);
        Recipes.recipes.addRecipe("water_rotor_assembler", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.water_rod.getStack(meta))), input.getInput(new ItemStack((ItemLike)IUItem.water_rod.getStack(meta))), input.getInput(new ItemStack((ItemLike)IUItem.water_rod.getStack(meta))), input.getInput(new ItemStack((ItemLike)IUItem.water_rod.getStack(meta))), input.getInput(new ItemStack((ItemLike)IUItem.corewater.getStack(meta1), 1))), new RecipeOutput(null, stack)));
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.water_rotor_assembler;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void init() {
        BlockEntityWaterRotorAssembler.addRecipe(0, 0, new ItemStack((ItemLike)IUItem.water_rotor_wood.getItem()));
        BlockEntityWaterRotorAssembler.addRecipe(1, 1, new ItemStack((ItemLike)IUItem.water_rotor_bronze.getItem()));
        BlockEntityWaterRotorAssembler.addRecipe(2, 2, new ItemStack((ItemLike)IUItem.water_rotor_iron.getItem()));
        BlockEntityWaterRotorAssembler.addRecipe(3, 3, new ItemStack((ItemLike)IUItem.water_rotor_steel.getItem()));
        BlockEntityWaterRotorAssembler.addRecipe(4, 4, new ItemStack((ItemLike)IUItem.water_rotor_carbon.getItem()));
        BlockEntityWaterRotorAssembler.addRecipe(5, 5, IUItem.water_iridium.getItemStack());
        BlockEntityWaterRotorAssembler.addRecipe(6, 6, IUItem.water_compressiridium.getItemStack());
        BlockEntityWaterRotorAssembler.addRecipe(7, 7, IUItem.water_spectral.getItemStack());
        BlockEntityWaterRotorAssembler.addRecipe(8, 8, IUItem.water_myphical.getItemStack());
        BlockEntityWaterRotorAssembler.addRecipe(10, 10, IUItem.water_photon.getItemStack());
        BlockEntityWaterRotorAssembler.addRecipe(9, 9, IUItem.water_neutron.getItemStack());
        BlockEntityWaterRotorAssembler.addRecipe(11, 11, IUItem.water_barionrotor.getItemStack());
        BlockEntityWaterRotorAssembler.addRecipe(12, 12, IUItem.water_adronrotor.getItemStack());
        BlockEntityWaterRotorAssembler.addRecipe(13, 13, IUItem.water_ultramarinerotor.getItemStack());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(this.getNBTFromSlot(customPacketBuffer));
            this.progress = (Short)DecoderHandler.decode(customPacketBuffer);
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.inputSlotA);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128448_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128376_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlotA.load();
        this.getOutput();
    }

    public void operate(MachineRecipe output) {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            List<ItemStack> processResult = output.getRecipe().output.items;
            this.operateOnce(processResult);
            if (!this.inputSlotA.continue_process(this.recipe) || !this.outputSlot.canAdd(output.getRecipe().output.items)) {
                this.getOutput();
                break;
            }
            if (this.recipe == null) break;
        }
    }

    public MachineRecipe getOutput() {
        this.recipe = this.inputSlotA.process();
        return this.recipe;
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.inputSlotA.consume();
        this.outputSlot.addAll(processResult);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.recipe != null && this.energy.canUseEnergy(this.energyConsume) && !this.inputSlotA.m_7983_() && this.outputSlot.canAdd(this.recipe.getRecipe().getOutput().items)) {
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate(this.recipe);
                this.progress = 0;
            }
        } else if (this.recipe == null) {
            this.progress = 0;
        }
    }

    public ContainerMenuWaterRotorAssembler getGuiContainer(Player entityPlayer) {
        return new ContainerMenuWaterRotorAssembler(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenWaterRotorAssembler((ContainerMenuWaterRotorAssembler)menu);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.recipe;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.recipe = output;
    }
}

