/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.SubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuShield;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.inventory.Inventory;
import com.denfop.items.modules.ItemEntityModule;
import com.denfop.network.DecoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.base.RenderType;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenShield;
import com.denfop.utils.CapturedMobUtils;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BlockEntityShield
extends BlockEntityInventory
implements IUpdatableTileEvent {
    final int latitudeSegments = 16;
    final int longitudeSegments = 16;
    private final Inventory slot;
    public boolean visibleShield = false;
    public boolean visibleLaser = false;
    Energy energy;
    List<Integer> integerList = new LinkedList<Integer>();
    AABB shieldBox;
    AABB shieldDefaultBox = new AABB(-8.0, -8.0, -8.0, 9.0, 9.0, 9.0);
    Vec3i center;
    LinkedList<LevelChunk> chunks = new LinkedList();
    List<UUID> uuidList = new LinkedList<UUID>();
    double[] sinLat = new double[17];
    double[] cosLat = new double[17];
    double[] sinLng = new double[17];
    double[] cosLng = new double[17];
    boolean write = false;
    double[][] x1 = new double[16][16];
    double[][] x2 = new double[16][16];
    double[][] x3 = new double[16][16];
    double[][] x4 = new double[16][16];
    double[][] y1 = new double[16][16];
    double[][] y2 = new double[16][16];
    double[][] y3 = new double[16][16];
    double[][] y4 = new double[16][16];
    double[][] z1 = new double[16][16];
    double[][] z2 = new double[16][16];
    double[][] z3 = new double[16][16];
    double[][] z4 = new double[16][16];
    @OnlyIn(value=Dist.CLIENT)
    private Function<RenderLevelStageEvent, Void> render;
    private double laserProgress;
    private byte mode = 0;
    private long lastShotTime = 0L;
    private boolean isShooting = false;

    public BlockEntityShield(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.shield, pos, state);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 10000.0, 14));
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 9){

            @Override
            public boolean m_7013_(int index, ItemStack stack) {
                if (!(stack.m_41720_() instanceof ItemEntityModule)) {
                    return false;
                }
                if (((SubEnum)((ItemEntityModule)stack.m_41720_()).getElement()).getId() == 0) {
                    return false;
                }
                return CapturedMobUtils.containsSoul(stack);
            }

            @Override
            public void update() {
                super.update();
                BlockEntityShield.this.integerList.clear();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).m_41619_()) continue;
                    CapturedMobUtils captured = CapturedMobUtils.create(this.get(i));
                    assert (captured != null);
                    LivingEntity entityLiving = (LivingEntity)captured.getEntity(((BlockEntityShield)this.base).getWorld(), true);
                    BlockEntityShield.this.integerList.add(entityLiving.m_19879_());
                }
            }
        };
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.m_128379_("VisibleShield", this.visibleShield);
        compound.m_128379_("VisibleLaser", this.visibleLaser);
        compound.m_128344_("Mode", this.mode);
        return compound;
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.visibleShield = compound.m_128471_("VisibleShield");
        this.visibleLaser = compound.m_128471_("VisibleLaser");
        this.mode = compound.m_128445_("Mode");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.slot.update();
        this.shieldBox = new AABB(this.getPos().m_7918_(-8, -8, -8), this.getPos().m_7918_(8, 8, 8));
        this.center = this.getPos().m_121955_(new Vec3i(0, 0, 0));
        int j2 = Mth.m_14107_((double)((this.shieldBox.f_82288_ - 2.0) / 16.0));
        int k2 = Mth.m_14165_((double)((this.shieldBox.f_82291_ + 2.0) / 16.0));
        int l2 = Mth.m_14107_((double)((this.shieldBox.f_82290_ - 2.0) / 16.0));
        int i3 = Mth.m_14165_((double)((this.shieldBox.f_82293_ + 2.0) / 16.0));
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                LevelChunk chunk = this.f_58857_.m_6325_(j3, k3);
                if (this.chunks.contains(chunk)) continue;
                this.chunks.add(chunk);
            }
        }
        if (this.getWorld().f_46443_) {
            this.render = this.createFunction();
            GlobalRenderManager.addRender(this.getWorld(), this.pos, this.render);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.getWorld().f_46443_) {
            GlobalRenderManager.removeRender(this.f_58857_, this.pos);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("uuid")) {
            try {
                UUID uuid = (UUID)DecoderHandler.decode(is);
                this.uuidList.add(uuid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("visibleShield")) {
            try {
                this.visibleShield = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("visibleLaser")) {
            try {
                this.visibleLaser = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mode")) {
            try {
                this.mode = (Byte)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Function<RenderLevelStageEvent, Void> createFunction() {
        Function<RenderLevelStageEvent, Void> function = o -> {
            int shieldColor;
            List mobs;
            if (this.shieldBox == null) {
                this.shieldBox = new AABB(this.getPos().m_7918_(-8, -8, -8), this.getPos().m_7918_(8, 8, 8));
                this.center = this.getPos().m_121955_(new Vec3i(0, 0, 0));
                int j2 = Mth.m_14107_((double)((this.shieldBox.f_82288_ - 2.0) / 16.0));
                int k2 = Mth.m_14165_((double)((this.shieldBox.f_82291_ + 2.0) / 16.0));
                int l2 = Mth.m_14107_((double)((this.shieldBox.f_82290_ - 2.0) / 16.0));
                int i3 = Mth.m_14165_((double)((this.shieldBox.f_82293_ + 2.0) / 16.0));
                for (int j3 = j2; j3 < k2; ++j3) {
                    for (int k3 = l2; k3 < i3; ++k3) {
                        LevelChunk chunk = this.f_58857_.m_6325_(j3, k3);
                        if (this.chunks.contains(chunk)) continue;
                        this.chunks.add(chunk);
                    }
                }
            }
            boolean mobNearby = !(mobs = this.f_58857_.m_6443_(Entity.class, this.shieldBox, e -> {
                boolean hasmob = e instanceof Mob;
                if (this.mode == 0) {
                    return hasmob && !this.integerList.contains(e.m_19879_());
                }
                return hasmob && this.integerList.contains(e.m_19879_());
            })).isEmpty();
            int n = shieldColor = mobNearby ? ModUtils.convertRGBcolorToInt(168, 0, 0) : 65535;
            if (this.visibleShield) {
                this.renderShield((RenderLevelStageEvent)o, this.shieldBox, shieldColor);
            }
            this.uuidList.clear();
            return null;
        };
        return function;
    }

    public Inventory getSlot() {
        return this.slot;
    }

    public byte getMode() {
        return this.mode;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.energy.getEnergy() >= 25.0) {
            boolean mobNearby;
            List mobs = this.f_58857_.m_6443_(Entity.class, this.shieldBox, e -> {
                boolean hasmob = e instanceof Mob;
                if (this.mode == 0) {
                    return hasmob && !this.integerList.contains(e.m_19879_());
                }
                return hasmob && this.integerList.contains(e.m_19879_());
            });
            boolean bl = mobNearby = !mobs.isEmpty();
            if (mobNearby) {
                for (Entity entity : mobs) {
                    if (!(this.energy.getEnergy() >= 25.0)) break;
                    new PacketUpdateFieldTile(this, "uuid", entity.m_20148_());
                    entity.m_6469_(entity.m_269291_().m_269425_(), 4.0f);
                    this.energy.useEnergy(25.0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderShield(RenderLevelStageEvent event, AABB box, int color) {
        double camX = event.getCamera().m_90583_().m_7096_();
        double camY = event.getCamera().m_90583_().m_7098_();
        double camZ = event.getCamera().m_90583_().m_7094_();
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        VertexConsumer bufferSource = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.LEASH_TRANSPARENT);
        Color color1 = new Color(color);
        if (!this.write) {
            this.writeData();
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        this.drawCircle(poseStack, bufferSource, this.pos, (float)color1.getRed() / 255.0f, (float)color1.getGreen() / 255.0f, (float)color1.getBlue() / 255.0f, 0.5f);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void writeData() {
        int i;
        this.write = true;
        for (i = 0; i <= 16; ++i) {
            double lat = Math.PI * (-0.5 + (double)i / 16.0);
            this.sinLat[i] = Math.sin(lat);
            this.cosLat[i] = Math.cos(lat);
        }
        for (int j = 0; j <= 16; ++j) {
            double lng = Math.PI * 2 * (double)j / 16.0;
            this.sinLng[j] = Math.sin(lng);
            this.cosLng[j] = Math.cos(lng);
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.x1[i][j] = this.cosLng[j] * this.cosLat[i];
                this.y1[i][j] = this.sinLat[i];
                this.z1[i][j] = this.sinLng[j] * this.cosLat[i];
                this.x2[i][j] = this.cosLng[j] * this.cosLat[i + 1];
                this.y2[i][j] = this.sinLat[i + 1];
                this.z2[i][j] = this.sinLng[j] * this.cosLat[i + 1];
                this.x3[i][j] = this.cosLng[j + 1] * this.cosLat[i + 1];
                this.y3[i][j] = this.sinLat[i + 1];
                this.z3[i][j] = this.sinLng[j + 1] * this.cosLat[i + 1];
                this.x4[i][j] = this.cosLng[j + 1] * this.cosLat[i];
                this.y4[i][j] = this.sinLat[i];
                this.z4[i][j] = this.sinLng[j + 1] * this.cosLat[i];
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawCircle(PoseStack poseStack, VertexConsumer bufferSource, BlockPos pos, float r, float g, float b, float alpha) {
        float x = (float)pos.m_123341_() + 0.5f;
        float y = (float)pos.m_123342_() + 0.5f;
        float z = (float)pos.m_123343_() + 0.5f;
        float radius = 8.0f;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                double x1 = this.x1[i][j];
                double y1 = this.y1[i][j];
                double z1 = this.z1[i][j];
                double x2 = this.x2[i][j];
                double y2 = this.y2[i][j];
                double z2 = this.z2[i][j];
                double x3 = this.x3[i][j];
                double y3 = this.y3[i][j];
                double z3 = this.z3[i][j];
                double x4 = this.x4[i][j];
                double y4 = this.y4[i][j];
                double z4 = this.z4[i][j];
                bufferSource.m_252986_(matrix, (float)((double)x + x1 * (double)radius), (float)((double)y + y1 * (double)radius), (float)((double)z + z1 * (double)radius)).m_85950_(r, g, b, 0.5f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x2 * (double)radius), (float)((double)y + y2 * (double)radius), (float)((double)z + z2 * (double)radius)).m_85950_(r, g, b, 0.5f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x3 * (double)radius), (float)((double)y + y3 * (double)radius), (float)((double)z + z3 * (double)radius)).m_85950_(r, g, b, 0.5f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x3 * (double)radius), (float)((double)y + y3 * (double)radius), (float)((double)z + z3 * (double)radius)).m_85950_(r, g, b, 0.5f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x4 * (double)radius), (float)((double)y + y4 * (double)radius), (float)((double)z + z4 * (double)radius)).m_85950_(r, g, b, 0.5f).m_5752_();
                bufferSource.m_252986_(matrix, (float)((double)x + x1 * (double)radius), (float)((double)y + y1 * (double)radius), (float)((double)z + z1 * (double)radius)).m_85950_(r, g, b, 0.5f).m_5752_();
            }
        }
    }

    public ContainerMenuShield getGuiContainer(Player var1) {
        return new ContainerMenuShield(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenShield((ContainerMenuShield)menu);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.shield;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0) {
            this.visibleLaser = true;
            new PacketUpdateFieldTile(this, "visibleLaser", this.visibleLaser);
        }
        if (var2 == 1.0) {
            this.visibleShield = true;
            new PacketUpdateFieldTile(this, "visibleShield", this.visibleShield);
        }
        if (var2 == -1.0) {
            this.visibleLaser = false;
            new PacketUpdateFieldTile(this, "visibleLaser", this.visibleLaser);
        }
        if (var2 == -2.0) {
            this.visibleShield = false;
            new PacketUpdateFieldTile(this, "visibleShield", this.visibleShield);
        }
        if (var2 == 2.0) {
            this.mode = 0;
            new PacketUpdateFieldTile(this, "mode", this.mode);
        }
        if (var2 == 3.0) {
            this.mode = 1;
            new PacketUpdateFieldTile(this, "mode", this.mode);
        }
    }
}

