/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockEntityRollingMachine
extends BlockEntityInventory
implements IUpdateTick,
IHasRecipe {
    public final InventoryRecipes inputSlotA;
    public final InventoryOutput outputSlot;
    public int progress = 0;
    public MachineRecipe output;
    public int tick = 0;
    public Map<UUID, Double> data = PrimitiveHandler.getPlayersData(EnumPrimitive.ROLLING);

    public BlockEntityRollingMachine(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.rolling_machine, pos, state);
        this.inputSlotA = new InventoryRecipes(this, "cutting", this){};
        this.outputSlot = new InventoryOutput(this, 1);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("primitive_rcm.info"));
        tooltip.add(Localization.translate("primitive_use.info") + IUItem.cutter.getItem().m_41466_().getString());
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.rolling_machine;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.ROLLING);
        if (!this.getWorld().f_46443_) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt(((Inventory)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt(((Inventory)DecoderHandler.decode(is)).writeToNbt(new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.f_41583_);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.f_41583_);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt(((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
            this.outputSlot.readFromNbt(((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt(new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.tick > 0) {
            --this.tick;
        }
        if (this.tick <= 10) {
            this.progress = 0;
        }
        this.setActive(this.tick >= 5);
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == IUItem.cutter.getItem() && this.output != null && this.inputSlotA.get(0).m_41613_() >= this.output.getRecipe().input.getInputs().get(0).getAmount() && this.outputSlot.canAdd(this.output.getRecipe().output.items.get(0))) {
            this.progress += (short)(10 + (short)(this.data.getOrDefault(player.m_20148_(), 0.0) / 5.0));
            this.getCooldownTracker().setTick(10);
            if (this.progress >= 100) {
                this.progress = 0;
                player.m_21008_(hand, stack.m_41720_().getCraftingRemainingItem(stack));
                if (!this.getWorld().f_46443_) {
                    PrimitiveHandler.addExperience(EnumPrimitive.ROLLING, 0.5, player.m_20148_());
                }
                this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (this.inputSlotA.m_7983_() || this.outputSlot.get(0).m_41613_() >= 64) {
                    this.output = null;
                }
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                }
            }
            this.tick = 25;
            return true;
        }
        if (!stack.m_41619_()) {
            if (this.inputSlotA.get(0).m_41619_() && this.inputSlotA.m_7013_(0, stack)) {
                this.inputSlotA.set(0, stack.m_41777_());
                stack.m_41764_(0);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
            if (!this.inputSlotA.get(0).m_41619_() && this.inputSlotA.get(0).m_150930_(stack.m_41720_())) {
                int minCount = 64 - this.inputSlotA.get(0).m_41613_();
                minCount = Math.min(stack.m_41613_(), minCount);
                this.inputSlotA.get(0).m_41769_(minCount);
                stack.m_41769_(-minCount);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.outputSlot.m_7983_()) {
                if (!this.f_58857_.f_46443_) {
                    ModUtils.dropAsEntity(this.f_58857_, this.pos, this.outputSlot.get(0));
                }
                this.outputSlot.set(0, ItemStack.f_41583_);
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
            if (!this.inputSlotA.m_7983_()) {
                if (!this.f_58857_.f_46443_) {
                    ModUtils.dropAsEntity(this.f_58857_, this.pos, this.inputSlotA.get(0));
                }
                this.inputSlotA.set(0, ItemStack.f_41583_);
                this.output = null;
                if (!this.f_58857_.f_46443_) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
    }
}

