/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockElectronicsAssemblerEntity;
import com.denfop.componets.ComponentProgress;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuElectronicsAssembler;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenElectronicsAssemble;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityPrimalElectronicsAssembler
extends BlockEntityElectricMachine
implements IUpdateTick,
IHasRecipe,
IUpdatableTileEvent {
    private static final int RED = 0;
    private static final int GRAY = 1;
    private static final int GREEN = 2;
    private static final int YELLOW = 3;
    private static final int SIZE = 146;
    private static Random random = new Random();
    public final ComponentProgress componentProgress;
    private final int MIN_DISTANCE = 5;
    private final int MAX_ATTEMPTS = 100;
    public InventoryRecipes inputSlotA;
    public MachineRecipe output = null;
    public boolean start;
    public int[] data;
    public Map<UUID, Double> data1;
    private int RED_PERCENT = 35;
    private int GREEN_PERCENT = 80;
    private int YELLOW_PERCENT = 100 - this.RED_PERCENT - this.GREEN_PERCENT;

    public BlockEntityPrimalElectronicsAssembler(BlockPos pos, BlockState state) {
        super(0.0, 0, 1, BlockElectronicsAssemblerEntity.electronics_assembler, pos, state);
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, 300));
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "electronics", (IUpdateTick)this);
        Recipes.recipes.addInitRecipes(this);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private int[] generateColorStrip() {
        int[] data = new int[146];
        this.fillGrayZones(data);
        this.createGrayGaps(data);
        this.createIslandsWithSpacing(data, 0, this.RED_PERCENT);
        this.createIslandsWithSpacing(data, 2, this.GREEN_PERCENT);
        this.placeYellow(data);
        return data;
    }

    private void fillGrayZones(int[] data) {
        for (int i = 0; i < 146; ++i) {
            data[i] = 1;
        }
    }

    private void createGrayGaps(int[] data) {
        int length;
        for (int index = 0; index < 146; index += length + 5) {
            length = random.nextInt(11) + 10;
            if (index + length > 146) {
                length = 146 - index;
            }
            for (int i = index; i < index + length; ++i) {
                data[i] = 1;
            }
        }
    }

    private void createIslandsWithSpacing(int[] data, int color, int percent) {
        int totalColorCount = 146 * percent / 100;
        int numIslands = random.nextInt(3) + 3;
        while (totalColorCount > 0 && numIslands > 0) {
            int attempts;
            int islandLength = random.nextInt(21) + 10;
            if (islandLength > totalColorCount) {
                islandLength = totalColorCount;
            }
            boolean placed = false;
            for (attempts = 0; !placed && attempts < 100; ++attempts) {
                int startIndex = random.nextInt(146 - islandLength);
                if (!this.isValidPlacement(data, startIndex, islandLength, color)) continue;
                for (int i = startIndex; i < startIndex + islandLength; ++i) {
                    data[i] = color;
                }
                totalColorCount -= islandLength;
                placed = true;
                --numIslands;
            }
            if (attempts < 100) continue;
            break;
        }
    }

    private boolean isValidPlacement(int[] data, int startIndex, int length, int color) {
        for (int i = startIndex; i < startIndex + length; ++i) {
            if (data[i] == 1) continue;
            return false;
        }
        if (startIndex > 0 && data[startIndex - 1] == color) {
            return false;
        }
        return startIndex + length >= 146 || data[startIndex + length] != color;
    }

    private void placeYellow(int[] data) {
        int yellowStart = random.nextInt(144);
        data[yellowStart] = 3;
        data[yellowStart + 1] = 3;
        if (yellowStart > 0) {
            data[yellowStart - 1] = 1;
        }
        if (yellowStart + 2 < 146) {
            data[yellowStart + 2] = 1;
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (this.start && var2 == 0.0) {
            this.componentProgress.addProgress(0, (short)(60.0 * (1.0 + this.data1.getOrDefault(var1.m_20148_(), 0.0) / 66.0)));
            if (this.componentProgress.getProgress(0) >= 300) {
                this.componentProgress.setProgress((short)300);
                if (!this.getWorld().f_46443_) {
                    PrimitiveHandler.addExperience(EnumPrimitive.ELECTRONIC, 0.75, var1.m_20148_());
                }
            }
            this.GREEN_PERCENT = (int)(80.0 * (1.0 - 0.75 * this.componentProgress.getBar()));
            this.RED_PERCENT = (int)(35.0 * (1.0 + 0.5 * this.componentProgress.getBar()));
            this.data = this.generateColorStrip();
        } else if (this.start && var2 == 1.0) {
            this.componentProgress.addProgress(0, (short)-10);
            if (this.componentProgress.getProgress(0) < 0) {
                this.componentProgress.setProgress((short)0);
            }
            this.GREEN_PERCENT = (int)(80.0 * (1.0 - 0.75 * this.componentProgress.getBar()));
            this.RED_PERCENT = (int)(35.0 * (1.0 + 0.5 * this.componentProgress.getBar()));
            this.data = this.generateColorStrip();
        } else if (this.start && var2 == 2.0) {
            this.componentProgress.setProgress(0, (short)300);
            if (!this.getWorld().f_46443_) {
                PrimitiveHandler.addExperience(EnumPrimitive.ELECTRONIC, 0.75, var1.m_20148_());
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlotA.load();
        this.getOutput();
        this.data1 = PrimitiveHandler.getPlayersData(EnumPrimitive.ELECTRONIC);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiChargeLevel = (Double)DecoderHandler.decode(customPacketBuffer);
            this.start = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.data = (int[])DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiChargeLevel);
            EncoderHandler.encode(packet, this.start);
            EncoderHandler.encode(packet, this.data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.start) {
            if (this.output != null) {
                if (this.inputSlotA.continue_process(this.output) && this.outputSlot.canAdd(this.output.getRecipe().getOutput().items)) {
                    this.start = true;
                    this.data = this.generateColorStrip();
                } else {
                    this.start = false;
                }
            }
        } else if (this.output == null) {
            this.start = false;
        }
        if (this.start && this.componentProgress.getBar() >= 1.0) {
            this.inputSlotA.consume();
            this.componentProgress.setProgress(0, (short)0);
            this.outputSlot.addAll(this.output.getRecipe().getOutput().items);
            this.getOutput();
        }
    }

    public ContainerMenuElectronicsAssembler getGuiContainer(Player entityPlayer) {
        return new ContainerMenuElectronicsAssembler(entityPlayer, this);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockElectronicsAssemblerEntity.electronics_assembler;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.electronics_assembler.getBlock();
    }

    @Override
    public void init() {
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public String getInventoryName() {
        return "Generation Microchip";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenElectronicsAssemble((ContainerMenuElectronicsAssembler)isAdmin);
    }

    public String getStartSoundFile() {
        return "Machines/genmirc.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

