/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityAntiMagnet;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine1Entity;
import com.denfop.componets.Energy;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuMagnet;
import com.denfop.containermenu.SlotInfo;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenMagnet;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Localization;
import com.denfop.utils.ParticleUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityMagnet
extends BlockEntityElectricMachine
implements IUpdatableTileEvent {
    public final SlotInfo slot;
    private final ComponentVisibleArea visible;
    public int energyconsume = 1000;
    public boolean work = true;
    public String player = "";
    public int x = 11;
    public int y = 11;
    public int z = 11;
    List<ChunkAccess> list = Lists.newArrayList();
    private AABB axisalignedbb;
    private ChunkPos chunkPos;

    public BlockEntityMagnet(BlockPos pos, BlockState state) {
        super(100000.0, 14, 24, BlockBaseMachine1Entity.magnet, pos, state);
        this.slot = new SlotInfo(this, 18, false);
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.energyconsume = (Integer)DecoderHandler.decode(customPacketBuffer);
            int prevX = this.x;
            int prevY = this.y;
            int prevZ = this.z;
            this.x = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.y = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.z = (Integer)DecoderHandler.decode(customPacketBuffer);
            if (prevX != this.x || prevY != this.y || prevZ != this.z) {
                this.updateData();
                this.visible.aabb = this.axisalignedbb;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.energyconsume);
            EncoderHandler.encode(packet, this.x);
            EncoderHandler.encode(packet, this.y);
            EncoderHandler.encode(packet, this.z);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.magnet.getSoundEvent();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.magnet_work_info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine1Entity.magnet;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.player = player.m_7755_().getString();
            for (int x = this.pos.m_123341_() - this.x; x <= this.pos.m_123341_() + this.x; ++x) {
                for (int y = this.pos.m_123342_() - this.y; y <= this.pos.m_123342_() + this.y; ++y) {
                    for (int z = this.pos.m_123343_() - this.z; z <= this.pos.m_123343_() + this.z; ++z) {
                        BlockPos pos1 = new BlockPos(x, y, z);
                        BlockEntity tileEntity = this.getWorld().m_7702_(pos1);
                        if (tileEntity == null || pos1.equals((Object)this.pos) || !(tileEntity instanceof BlockEntityAntiMagnet)) continue;
                        BlockEntityAntiMagnet tile = (BlockEntityAntiMagnet)tileEntity;
                        if (tile.player.equals(this.player)) continue;
                        this.work = false;
                    }
                }
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.player = nbttagcompound.m_128461_("player");
        this.work = nbttagcompound.m_128471_("work");
        this.x = nbttagcompound.m_128451_("x1");
        this.y = nbttagcompound.m_128451_("y1");
        this.z = nbttagcompound.m_128451_("z1");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128359_("player", this.player);
        nbttagcompound.m_128379_("work", this.work);
        nbttagcompound.m_128405_("x1", this.x);
        nbttagcompound.m_128405_("y1", this.y);
        nbttagcompound.m_128405_("z1", this.z);
        return nbttagcompound;
    }

    public boolean canInsertOrExtract(ItemStack stack) {
        List<ItemStack> BlackItemStacks = this.slot.getListBlack();
        if (BlackItemStacks.isEmpty()) {
            List<ItemStack> WhiteItemStacks = this.slot.getListWhite();
            if (!WhiteItemStacks.isEmpty()) {
                for (ItemStack stack1 : WhiteItemStacks) {
                    if (!stack1.m_150930_(stack.m_41720_())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (ItemStack stack1 : BlackItemStacks) {
            if (!stack1.m_150930_(stack.m_41720_())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateData();
    }

    public void updateData() {
        this.axisalignedbb = new AABB((double)(this.m_58899_().m_123341_() - this.x), (double)(this.m_58899_().m_123342_() - this.y), (double)(this.m_58899_().m_123343_() - this.z), (double)(this.m_58899_().m_123341_() + this.x + 1), (double)(this.m_58899_().m_123342_() + this.y + 1), (double)(this.m_58899_().m_123343_() + this.z + 1));
        this.chunkPos = new ChunkPos(this.getPos());
        int j2 = (int)Math.floor(this.axisalignedbb.f_82288_ / 16.0);
        int k2 = (int)Math.ceil(this.axisalignedbb.f_82291_ / 16.0);
        int l2 = (int)Math.floor(this.axisalignedbb.f_82290_ / 16.0);
        int i3 = (int)Math.ceil(this.axisalignedbb.f_82293_ / 16.0);
        this.list = Lists.newArrayList();
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                LevelChunk chunk = this.m_58904_().m_6325_(j3, k3);
                if (this.list.contains(chunk)) continue;
                this.list.add((ChunkAccess)chunk);
            }
        }
        this.visible.aabb = this.axisalignedbb;
    }

    public List<ItemEntity> getEntitiesWithinAABB() {
        ArrayList list = Lists.newArrayList();
        LevelEntityGetter list1 = ((ServerLevel)this.f_58857_).m_142646_();
        this.list.forEach(chunk -> list1.m_142232_(this.axisalignedbb.m_82386_((double)((chunk.m_7697_().f_45578_ - this.chunkPos.f_45578_) * 16), 0.0, (double)((chunk.m_7697_().f_45579_ - this.chunkPos.f_45579_) * 16)), p_151522_ -> {
            if (p_151522_ instanceof ItemEntity && this.axisalignedbb.m_82390_(p_151522_.m_20182_())) {
                list.add((ItemEntity)p_151522_);
            }
        }));
        return list;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.work) {
            return;
        }
        if (this.getActive()) {
            ParticleUtils.spawnMagneticCatcherParticles(this.f_58857_, this.pos, this.f_58857_.f_46441_);
        }
        boolean ret = false;
        if (this.getWorld().m_46467_() % 4L == 0L) {
            List<ItemEntity> list = this.getEntitiesWithinAABB();
            for (ItemEntity item : list) {
                ItemStack stack;
                if (item.m_213877_() || !this.energy.canUseEnergy(this.energyconsume) || !this.outputSlot.canAdd(stack = item.m_32055_()) || !this.canInsertOrExtract(item.m_32055_())) continue;
                item.m_142467_(Entity.RemovalReason.KILLED);
                this.initiate(0);
                this.setActive(true);
                this.energy.useEnergy(this.energyconsume);
                this.outputSlot.add(stack);
                ret = true;
            }
        }
        if (this.getWorld().m_46467_() % 10L == 0L && !ret && this.getActive()) {
            this.setActive(false);
            this.initiate(2);
        }
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (event == 10.0) {
            super.updateTileServer(player, event);
        } else {
            if (event == 0.0) {
                --this.x;
                this.x = Math.max(1, this.x);
            }
            if (event == 1.0) {
                ++this.x;
                this.x = Math.min(11, this.x);
            }
            if (event == 2.0) {
                --this.y;
                this.y = Math.max(1, this.y);
            }
            if (event == 3.0) {
                ++this.y;
                this.y = Math.min(11, this.y);
            }
            if (event == 4.0) {
                --this.z;
                this.z = Math.max(1, this.z);
            }
            if (event == 5.0) {
                ++this.z;
                this.z = Math.min(11, this.z);
            }
            this.updateData();
        }
    }

    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenMagnet((ContainerMenuMagnet)isAdmin);
    }

    public ContainerMenuMagnet getGuiContainer(Player entityPlayer) {
        return new ContainerMenuMagnet(entityPlayer, this);
    }
}

