/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.chemicalplant;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.blockentity.chemicalplant.IController;
import com.denfop.blockentity.chemicalplant.IExchanger;
import com.denfop.blockentity.chemicalplant.IGenerator;
import com.denfop.blockentity.chemicalplant.ISeparate;
import com.denfop.blockentity.chemicalplant.IWaste;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockChemicalPlantEntity;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuChemicalController;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.screen.ScreenChemicalController;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockEntityChemicalPlantController
extends BlockEntityMultiBlockBase
implements IController {
    public boolean work = false;
    List<IGenerator> generatorList = new ArrayList<IGenerator>();
    IWaste waste;
    List<ISeparate> separateList = new ArrayList<ISeparate>();
    List<IExchanger> exchangerList = new ArrayList<IExchanger>();

    public BlockEntityChemicalPlantController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.ChemicalPlantMultiBlock, BlockChemicalPlantEntity.chemical_plant_controller, pos, state);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockChemicalPlantEntity.chemical_plant_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.chemicalPlant.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound.m_128379_("work", this.work);
        return super.writeToNBT(nbttagcompound);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.isFull()) {
            Fluids.InternalFluidTank fluidTankWaste = this.waste.getFluidTank();
            int canAdd = fluidTankWaste.getCapacity() - fluidTankWaste.getFluidAmount();
            if (canAdd == 0) {
                return;
            }
            int defaultAdd = canAdd;
            for (ISeparate separate : this.separateList) {
                if (defaultAdd == 0) {
                    return;
                }
                Fluids.InternalFluidTank fluidTank = separate.getFluidTank();
                if (fluidTank.getFluidAmount() == 0) continue;
                canAdd = Math.min(Math.min(defaultAdd, fluidTank.getFluidAmount() / 10), 10);
                if (canAdd == 0) {
                    return;
                }
                double energy = 0.0;
                for (IGenerator generator : this.generatorList) {
                    energy += generator.getEnergy().getEnergy();
                }
                canAdd = (int)Math.min(energy / 5.0, (double)canAdd);
                block2: for (IExchanger exchanger : this.exchangerList) {
                    if (canAdd == 0) {
                        return;
                    }
                    Fluids.InternalFluidTank fluidTank1 = exchanger.getFluidTank();
                    int canAdd1 = (int)Math.min((double)canAdd, (double)fluidTank1.getFluidAmount() / 2.0);
                    defaultAdd -= canAdd1;
                    canAdd -= canAdd1;
                    fluidTankWaste.fill(new FluidStack((Fluid)FluidName.fluidcryogen.getInstance().get(), canAdd1), IFluidHandler.FluidAction.EXECUTE);
                    fluidTank1.drain(canAdd1 * 2, IFluidHandler.FluidAction.EXECUTE);
                    fluidTank.drain(canAdd1 * 10, IFluidHandler.FluidAction.EXECUTE);
                    double energy1 = canAdd1 * 5;
                    for (IGenerator generator : this.generatorList) {
                        if (generator.getEnergy().getEnergy() > energy1) {
                            generator.getEnergy().useEnergy(energy1);
                            continue block2;
                        }
                        energy1 -= generator.getEnergy().getEnergy();
                        generator.getEnergy().useEnergy(generator.getEnergy().getEnergy());
                    }
                }
            }
        }
    }

    public ContainerMenuChemicalController getGuiContainer(Player entityPlayer) {
        return new ContainerMenuChemicalController(this, entityPlayer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player var1, ContainerMenuBase<?> var2) {
        return new ScreenChemicalController((ContainerMenuChemicalController)var2);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.generatorList.clear();
            this.exchangerList.clear();
            this.separateList.clear();
            this.waste = null;
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IWaste.class);
        this.waste = (IWaste)this.getWorld().m_7702_(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IGenerator.class);
        for (BlockPos pos3 : pos2) {
            this.generatorList.add((IGenerator)this.getWorld().m_7702_(pos3));
        }
        pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), ISeparate.class);
        for (BlockPos pos3 : pos2) {
            this.separateList.add((ISeparate)this.getWorld().m_7702_(pos3));
        }
        pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.m_58899_(), IExchanger.class);
        for (BlockPos pos3 : pos2) {
            this.exchangerList.add((IExchanger)this.getWorld().m_7702_(pos3));
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.m_128471_("work");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
    }

    @Override
    public void usingBeforeGUI() {
    }
}

