/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSolidMatter;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSolidMatter;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BlockEntityMatterGenerator
extends BlockEntityInventory
implements IUpgradableBlock {
    public final InventoryOutput outputSlot;
    public final ItemStack itemstack;
    public final InventoryUpgrade upgradeSlot;
    private final Energy energy;
    private final String name;
    private double progress;

    public BlockEntityMatterGenerator(ItemStack itemstack, String name, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.itemstack = itemstack;
        this.outputSlot = new InventoryOutput(this, 1);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.progress = 0.0;
        this.name = name;
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 5.0E7, 10));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(10.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        Energy energy;
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.matter_solid_work_info") + "50000000");
        }
        if (!(energy = this.energy).getSourceDirs().isEmpty()) {
            tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
        } else if (!energy.getSinkDirs().isEmpty()) {
            tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.m_128459_("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128347_("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean active = false;
        if (this.energy.getEnergy() > 0.0) {
            active = true;
            this.progress = this.energy.getEnergy() / this.energy.getCapacity();
            if (this.energy.getEnergy() >= this.energy.getCapacity() && this.outputSlot.add(this.itemstack)) {
                this.energy.useEnergy(this.energy.getCapacity());
                this.progress = 0.0;
            }
        }
        this.setActive(active);
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenSolidMatter((ContainerMenuSolidMatter)isAdmin);
    }

    public ContainerMenuSolidMatter getGuiContainer(Player entityPlayer) {
        return new ContainerMenuSolidMatter(entityPlayer, this);
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(BlockEntityMatterGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemInput, UpgradableProperty.ItemExtract);
    }

    public final float getChargeLevel() {
        return Math.min((float)this.energy.getEnergy() / (float)this.energy.getCapacity(), 1.0f);
    }

    public double getProgress() {
        return this.progress;
    }

    public int getMode() {
        return 0;
    }

    public String getInventoryName() {
        return this.name;
    }
}

