/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.sound.AudioFixer;
import com.denfop.api.sound.EnumTypeAudio;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.EnumDoubleElectricMachine;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.TypeUpgrade;
import com.denfop.containermenu.ContainerMenuDoubleElectricMachine;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryDischarge;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockEntityDoubleElectricMachine
extends BlockEntityInventory
implements AudioFixer,
IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent {
    public final Energy energy;
    public final InventoryDischarge dischargeSlot;
    public final InventoryRecipes inputSlotA;
    public final InventoryOutput outputSlot;
    public final InventoryUpgrade upgradeSlot;
    public final HeatComponent heat;
    protected final EnumDoubleElectricMachine type;
    private final ComponentUpgrade componentUpgrades;
    public MachineRecipe output;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    public ComponentUpgradeSlots componentUpgrade;
    public ComponentProgress componentProgress;
    public ComponentProcess componentProcess;
    private boolean sound = true;

    public BlockEntityDoubleElectricMachine(int energyPerTick, int length, int outputSlots, EnumDoubleElectricMachine type, MultiBlockEntity block, BlockPos pos, BlockState state) {
        this(energyPerTick, length, outputSlots, 1, type, true, block, pos, state);
    }

    public BlockEntityDoubleElectricMachine(int energyPerTick, int length, int outputSlots, EnumDoubleElectricMachine type, boolean register, MultiBlockEntity block, BlockPos pos, BlockState state) {
        this(energyPerTick, length, outputSlots, 1, type, register, block, pos, state);
    }

    public BlockEntityDoubleElectricMachine(int energyPerTick, int length, int outputSlots, int aDefaultTier, EnumDoubleElectricMachine type, boolean register, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.outputSlot = new InventoryOutput(this, outputSlots);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.dischargeSlot = new InventoryDischarge(this, Inventory.TypeItemSlot.INPUT, aDefaultTier, false);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, (double)energyPerTick * (double)length, aDefaultTier).addManagedSlot(this.dischargeSlot));
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, type.recipe_name, (IUpdateTick)this);
        this.type = type;
        this.output = null;
        this.heat = type.heat ? this.addComponent(HeatComponent.asBasicSink(this, 5000.0)) : null;
        if (register) {
            this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
            this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, (short)length));
            this.componentProcess = this.addComponent(new ComponentProcess(this, length, energyPerTick));
            this.componentProcess.setHasAudio(true);
            this.componentProcess.setSlotOutput(this.outputSlot);
            this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        }
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        this.sound = !this.sound;
        new PacketUpdateFieldTile(this, "sound", this.sound);
        if (!this.sound && this.getTypeAudio() == EnumTypeAudio.ON) {
            this.setType(EnumTypeAudio.OFF);
            new PacketStopSound(this.getWorld(), this.m_58899_());
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.sound);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onNetworkEvent(int var1) {
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (this.type == EnumDoubleElectricMachine.ALLOY_SMELTER) {
            if (!Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("iu.heatmachine.info"));
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProgress.getMaxValue());
            }
        } else if (EnumDoubleElectricMachine.SUNNARIUM_PANEL == this.type) {
            if (!Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("iu.solarium_energy_sink.info"));
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_energy") + "5" + Localization.translate("iu.machines_work_energy_type_se"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProgress.getMaxValue());
            }
        } else {
            if (!Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
            }
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (this.sound) {
            if (this.getSound() == null) {
                return;
            }
            if (soundEvent == 0) {
                this.getWorld().m_5594_(null, this.m_58899_(), this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (soundEvent == 1) {
                new PacketStopSound(this.getWorld(), this.m_58899_());
                this.getWorld().m_5594_(null, this.m_58899_(), EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                new PacketStopSound(this.getWorld(), this.m_58899_());
            }
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.m_128471_("sound");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.m_128379_("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().f_46443_) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    public ContainerMenuDoubleElectricMachine getGuiContainer(Player entityPlayer) {
        return new ContainerMenuDoubleElectricMachine(entityPlayer, this, this.type);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    public final float getChargeLevel() {
        return Math.min((float)this.energy.getEnergy() / (float)this.energy.getCapacity(), 1.0f);
    }

    public double getProgress() {
        return this.componentProgress.getBar();
    }

    public int getMode() {
        return 0;
    }
}

