/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuCombinerSE;
import com.denfop.inventory.InventoryCombinerSEG;
import com.denfop.inventory.InventoryGenCombinerSunarrium;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenCombinerSE;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEntityCombinerSEGenerators
extends BlockEntityInventory
implements IUpgradableBlock {
    public final InventoryCombinerSEG inputSlot;
    public final InventoryUpgrade upgradeSlot;
    public final InventoryOutput outputSlot;
    public final ComponentBaseEnergy sunenergy;
    public final InventoryGenCombinerSunarrium input;
    public final ItemStack itemstack = new ItemStack((ItemLike)IUItem.sunnarium.getStack(4), 1);
    public double coef_day;
    public double coef_night;
    public double update_night;
    public int count;
    public List<Double> lst;
    public int coef = 0;
    public double generation;
    private boolean noSunWorld;
    private boolean skyIsVisible;
    private boolean sunIsUp;

    public BlockEntityCombinerSEGenerators(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.combiner_se_generators, pos, state);
        this.inputSlot = new InventoryCombinerSEG(this);
        this.input = new InventoryGenCombinerSunarrium(this);
        this.outputSlot = new InventoryOutput(this, 9);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.sunenergy = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.SOLARIUM, this, 0.0, 1));
        this.lst = new ArrayList<Double>();
        this.lst.add(0.0);
        this.lst.add(0.0);
        this.lst.add(0.0);
        this.coef_day = 0.0;
        this.coef_night = 0.0;
        this.update_night = 0.0;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.combiner_se_generators;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public int getInventoryStackLimit() {
        return 4;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.generation = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.generation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlot.update();
        this.lst = this.input.coefday();
        this.coef_day = this.lst.get(0);
        this.coef_night = this.lst.get(1);
        this.update_night = this.lst.get(2);
        this.noSunWorld = this.f_58857_.m_46472_() == Level.f_46429_;
        this.updateVisibility();
    }

    public void updateVisibility() {
        this.skyIsVisible = this.m_58904_().m_45527_(this.f_58858_) && this.m_58904_().m_8055_(this.f_58858_.m_7494_()).m_284242_((BlockGetter)this.m_58904_(), this.f_58858_.m_7494_()) == MapColor.f_283808_ && !this.noSunWorld;
        this.sunIsUp = this.m_58904_().m_46461_();
    }

    public void energy(long tick) {
        double k = 0.0;
        if (this.sunIsUp) {
            if (tick <= 1000L) {
                k = 5.0;
            }
            if (tick > 1000L && tick <= 4000L) {
                k = 10.0;
            }
            if (tick > 4000L && tick <= 8000L) {
                k = 30.0;
            }
            if (tick > 8000L && tick <= 11000L) {
                k = 10.0;
            }
            if (tick > 11000L) {
                k = 5.0;
            }
            this.generation = k * (double)this.coef * (1.0 + this.coef_day);
            this.sunenergy.addEnergy(this.generation);
        }
        if (this.update_night > 0.0 && !this.sunIsUp) {
            double tick1 = tick - 12000L;
            if (tick1 <= 1000.0) {
                k = 5.0;
            }
            if (tick1 > 1000.0 && tick1 <= 4000.0) {
                k = 10.0;
            }
            if (tick1 > 4000.0 && tick1 <= 8000.0) {
                k = 30.0;
            }
            if (tick1 > 8000.0 && tick1 <= 11000.0) {
                k = 10.0;
            }
            if (tick1 > 11000.0) {
                k = 5.0;
            }
            this.generation = k * (double)this.coef * (this.update_night - 1.0) * (1.0 + this.coef_night);
            this.sunenergy.addEnergy(this.generation);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.f_58857_.m_46467_() % 80L == 0L) {
            this.updateVisibility();
            this.inputSlot.update();
        }
        long tick = this.getWorld().m_46467_() % 24000L;
        this.generation = 0.0;
        if (this.skyIsVisible) {
            this.energy(tick);
            while (this.sunenergy.getEnergy() >= 9000.0 && this.outputSlot.add(this.itemstack)) {
                this.sunenergy.addEnergy(-9000.0);
            }
        }
        this.upgradeSlot.tickNoMark();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenCombinerSE((ContainerMenuCombinerSE)menu);
    }

    public ContainerMenuCombinerSE getGuiContainer(Player entityPlayer) {
        return new ContainerMenuCombinerSE(entityPlayer, this);
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemExtract);
    }

    public String getInventoryName() {
        return null;
    }
}

