/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.widget.ButtonListSliderWidget;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SliderWidget
extends AbstractWidget {
    protected static final ResourceLocation TEXTURES = new ResourceLocation("industrialupgrade", "textures/gui/slider.png");
    private final String name;
    private final float min;
    private final float max;
    private final int id;
    public boolean isMouseDown;
    public ButtonListSliderWidget.WidgetResponder responder;
    public FormatHelper formatHelper;
    private String displayString1;
    private float sliderPosition = 1.0f;

    public SliderWidget(ButtonListSliderWidget.WidgetResponder p_i45541_1_, int p_i45541_2_, int p_i45541_3_, int p_i45541_4_, String p_i45541_5_, float p_i45541_6_, float p_i45541_7_, float p_i45541_8_, FormatHelper p_i45541_9_) {
        super(p_i45541_3_, p_i45541_4_, 150, 1, (Component)Component.m_237113_((String)""));
        this.id = p_i45541_2_;
        this.name = p_i45541_5_;
        this.min = p_i45541_6_;
        this.max = p_i45541_7_;
        this.sliderPosition = (p_i45541_8_ - p_i45541_6_) / (p_i45541_7_ - p_i45541_6_);
        this.formatHelper = p_i45541_9_;
        this.responder = p_i45541_1_;
        this.displayString1 = this.getDisplayString();
    }

    public SliderWidget(ButtonListSliderWidget.WidgetResponder p_i45541_1_, int p_i45541_2_, int p_i45541_3_, int p_i45541_4_, String p_i45541_5_, float p_i45541_6_, float p_i45541_7_, float p_i45541_8_, FormatHelper p_i45541_9_, int width) {
        super(p_i45541_3_, p_i45541_4_, width, 1, (Component)Component.m_237113_((String)""));
        this.id = p_i45541_2_;
        this.name = p_i45541_5_;
        this.min = p_i45541_6_;
        this.max = p_i45541_7_;
        this.sliderPosition = (p_i45541_8_ - p_i45541_6_) / (p_i45541_7_ - p_i45541_6_);
        this.formatHelper = p_i45541_9_;
        this.responder = p_i45541_1_;
        this.displayString1 = this.getDisplayString();
    }

    public float getSliderValue() {
        return this.min + (this.max - this.min) * this.sliderPosition;
    }

    public void setSliderValue(float p_175218_1_, boolean p_175218_2_) {
        this.sliderPosition = (p_175218_1_ - this.min) / (this.max - this.min);
        this.displayString1 = this.getDisplayString();
        if (p_175218_2_) {
            this.responder.setEntryValue(this.id, this.getSliderValue());
        }
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169143_(NarratedElementType.TITLE, this.getDisplayString());
    }

    public float getSliderPosition() {
        return this.sliderPosition;
    }

    public void setSliderPosition(float p_175219_1_) {
        this.sliderPosition = p_175219_1_;
        this.displayString1 = this.getDisplayString();
        this.responder.setEntryValue(this.id, this.getSliderValue());
    }

    private String getDisplayString() {
        return this.formatHelper == null ? Localization.translate(this.name, new Object[0]) + ": " + this.getSliderValue() : this.formatHelper.getText(this.id, Localization.translate(this.name, new Object[0]), this.getSliderValue());
    }

    protected int getHoverState(boolean p_146114_1_) {
        return 0;
    }

    public boolean m_7979_(double p_146119_2_, double p_146119_3_, int button, double dragX, double dragY) {
        if (this.f_93624_) {
            if (this.isMouseDown && this.m_5953_(this.m_252754_(), p_146119_3_)) {
                this.updateSliderPosition(p_146119_2_);
                this.displayString1 = this.getDisplayString();
                this.responder.setEntryValue(this.id, this.getSliderValue());
                return true;
            }
            return false;
        }
        return false;
    }

    private void updateSliderPosition(double mouseX) {
        this.sliderPosition = (float)(mouseX - (double)(this.m_252754_() + 4)) / (float)(this.f_93618_ - 8);
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > 1.0f) {
            this.sliderPosition = 1.0f;
        }
        this.responder.setEntryValue(this.id, Math.round(this.getSliderValue()));
    }

    protected void m_87963_(GuiGraphics guiGraphics, int i, int i1, float v) {
        ScreenIndustrialUpgrade.bindTexture(TEXTURES);
        guiGraphics.m_280218_(ScreenIndustrialUpgrade.currentTexture, this.m_252754_(), this.m_252907_(), 0, 255, this.f_93618_, 1);
        guiGraphics.m_280218_(ScreenIndustrialUpgrade.currentTexture, this.m_252754_(), this.m_252907_() - 2, 6, 13, 1, 4);
        guiGraphics.m_280218_(ScreenIndustrialUpgrade.currentTexture, this.m_252754_() + this.f_93618_ - 1, this.m_252907_() - 2, 6, 13, 1, 4);
        guiGraphics.m_280218_(ScreenIndustrialUpgrade.currentTexture, this.m_252754_() + this.f_93618_ / 2, this.m_252907_() - 2, 6, 13, 1, 4);
        for (int x = this.m_252754_() + this.f_93618_ / 4; x < this.m_252754_() + this.f_93618_ - 1; x += this.f_93618_ / 4) {
            guiGraphics.m_280218_(ScreenIndustrialUpgrade.currentTexture, x + 1, this.m_252907_() - 1, 9, 14, 1, 3);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(ScreenIndustrialUpgrade.currentTexture, this.m_252754_() + (int)(this.sliderPosition * (float)(this.f_93618_ - 3)), this.m_252907_() - 2, 12, 13, 3, 5);
        int j = 0xE0E0E0;
        if (this.packedFGColor != 0) {
            j = this.packedFGColor;
        } else if (!this.f_93623_) {
            j = 0xA0A0A0;
        } else if (this.f_93622_) {
            j = 0xFFFFA0;
        }
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, this.getDisplayString(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + -3 - 8, j);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.isMouseDown = true;
            this.updateSliderPosition(mouseX);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isMouseDown = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.m_252754_() - 4 && mouseX < this.m_252754_() + 4 + this.f_93618_ && mouseY >= this.m_252907_() - 4 && mouseY < this.m_252907_() + 8 + this.f_93619_;
    }

    public boolean handleMouseWheel(ScrollDirection direction, int mouseX, int mouseY) {
        if (this.f_93624_ && this.f_93623_ && this.isMouseOver(mouseX, mouseY)) {
            float step = 1.0f / (this.max - this.min);
            this.sliderPosition += direction == ScrollDirection.down ? step : -step;
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.displayString1 = this.getDisplayString();
            this.responder.setEntryValue(this.id, Math.round(this.getSliderValue()));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface FormatHelper {
        public String getText(int var1, String var2, float var3);
    }
}

