/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.water.upgrade;

import com.denfop.IUItem;
import com.denfop.api.water.upgrade.EnumInfoRotorUpgradeModules;
import com.denfop.api.water.upgrade.IRotorUpgradeItem;
import com.denfop.api.water.upgrade.IRotorUpgradeSystem;
import com.denfop.api.water.upgrade.RotorUpgradeItemInform;
import com.denfop.api.water.upgrade.event.EventRotorItemLoad;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RotorUpgradeSystem
implements IRotorUpgradeSystem {
    public static IRotorUpgradeSystem instance;
    Map<Integer, List<RotorUpgradeItemInform>> map = new HashMap<Integer, List<RotorUpgradeItemInform>>();
    Map<Integer, ItemStack> map_stack;
    Map<Integer, Integer> map_col = new HashMap<Integer, Integer>();
    int max = 0;

    public RotorUpgradeSystem() {
        this.map_stack = new HashMap<Integer, ItemStack>();
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void loadItem(EventRotorItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @Override
    public int getRemaining(ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        return this.map_col.getOrDefault(id, 4);
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        int id = nbt.m_128451_("ID_Item");
        ItemStack item = this.map_stack.get(id);
        if (item == null || item.m_41619_()) {
            return false;
        }
        int id1 = ModUtils.nbt(item).m_128451_("ID_Item");
        return item.m_150930_(stack.m_41720_()) && id1 == id && item.m_41783_() != null && item.m_41783_().equals((Object)stack.m_41783_());
    }

    @Override
    public List<RotorUpgradeItemInform> getInformation(ItemStack item) {
        CompoundTag nbt = ModUtils.nbt(item);
        int id = nbt.m_128451_("ID_Item");
        ArrayList list = this.map.get(id);
        return list != null ? list : new ArrayList();
    }

    @Override
    public RotorUpgradeItemInform getModules(EnumInfoRotorUpgradeModules module, ItemStack item) {
        List<RotorUpgradeItemInform> list = this.getInformation(item);
        for (RotorUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public RotorUpgradeItemInform getModules(EnumInfoRotorUpgradeModules module, List<RotorUpgradeItemInform> list) {
        for (RotorUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumInfoRotorUpgradeModules module, ItemStack item) {
        if (!(item.m_41720_() instanceof IRotorUpgradeItem)) {
            return false;
        }
        List<RotorUpgradeItemInform> list = this.getInformation(item);
        for (RotorUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModules(EnumInfoRotorUpgradeModules module, ItemStack item, List<RotorUpgradeItemInform> list) {
        if (!(item.m_41720_() instanceof IRotorUpgradeItem)) {
            return false;
        }
        for (RotorUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IRotorUpgradeItem item, ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        boolean hasID = nbt.m_128471_("hasID");
        int id = nbt.m_128451_("ID_Item");
        if (!hasID) {
            id = this.max++;
            nbt.m_128405_("ID_Item", id);
            nbt.m_128379_("hasID", true);
        }
        ArrayList<EnumInfoRotorUpgradeModules> lst = new ArrayList<EnumInfoRotorUpgradeModules>();
        int empty = 0;
        boolean canupgrade = false;
        for (int i = 0; i < 4; ++i) {
            String name = nbt.m_128461_("mode_module" + i);
            if (name.equals("")) {
                ++empty;
                canupgrade = true;
            }
            if (name.equals("")) continue;
            for (EnumInfoRotorUpgradeModules enumInfoRotorUpgradeModules : EnumInfoRotorUpgradeModules.values()) {
                if (!enumInfoRotorUpgradeModules.name.equals(name)) continue;
                lst.add(enumInfoRotorUpgradeModules);
            }
        }
        int ost = empty;
        nbt.m_128379_("canupgrade", canupgrade);
        if (this.map_col.containsKey(id)) {
            this.map_col.replace(id, ost);
        } else {
            this.map_col.put(id, ost);
        }
        this.setInformation(item, lst, stack);
    }

    @Override
    public void setInformation(IRotorUpgradeItem item, List<EnumInfoRotorUpgradeModules> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        this.map.clear();
        this.max = 0;
        this.map_col.clear();
        this.map_stack.clear();
    }

    @Override
    public void write(IRotorUpgradeItem item, List<EnumInfoRotorUpgradeModules> lst, ItemStack stack) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Object upgrade : lst) {
            if (map.containsKey(upgrade)) {
                map.replace(upgrade, (Integer)map.get(upgrade) + 1);
                continue;
            }
            map.put(upgrade, 1);
        }
        ArrayList<RotorUpgradeItemInform> list = new ArrayList<RotorUpgradeItemInform>();
        for (Map.Entry entry : map.entrySet()) {
            list.add(new RotorUpgradeItemInform((EnumInfoRotorUpgradeModules)((Object)entry.getKey()), (Integer)entry.getValue()));
        }
        CompoundTag nbt = ModUtils.nbt(stack);
        int n = nbt.m_128451_("ID_Item");
        if (!this.map.containsKey(n)) {
            this.map.put(n, list);
            this.map_stack.put(n, stack);
        } else {
            this.map.replace(n, list);
            this.map_stack.replace(n, stack);
        }
    }

    @Override
    public void removeUpdate(ItemStack stack, Level world, int index) {
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.m_128359_("mode_module" + index, "");
        MinecraftForge.EVENT_BUS.post((Event)new EventRotorItemLoad(world, (IRotorUpgradeItem)stack.m_41720_(), stack));
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        CompoundTag nbt = ModUtils.nbt(stack);
        for (int i = 0; i < 4; ++i) {
            String name = nbt.m_128461_("mode_module" + i);
            if (!name.isEmpty()) {
                for (EnumInfoRotorUpgradeModules enumInfoRotorUpgradeModules : EnumInfoRotorUpgradeModules.values()) {
                    if (!enumInfoRotorUpgradeModules.name.equals(name)) continue;
                    list.add(new ItemStack((ItemLike)IUItem.water_rotors_upgrade.getStack(enumInfoRotorUpgradeModules.ordinal()), 1));
                }
                continue;
            }
            list.add(ItemStack.f_41583_);
        }
        return list;
    }

    @Override
    public Map<Integer, ItemStack> getList(ItemStack stack) {
        CompoundTag nbt = ModUtils.nbt(stack);
        HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < 4; ++i) {
            String name = nbt.m_128461_("mode_module" + i);
            if (!name.isEmpty()) {
                for (EnumInfoRotorUpgradeModules enumInfoRotorUpgradeModules : EnumInfoRotorUpgradeModules.values()) {
                    if (!enumInfoRotorUpgradeModules.name.equals(name)) continue;
                    map.put(i, new ItemStack((ItemLike)IUItem.water_rotors_upgrade.getStack(enumInfoRotorUpgradeModules.ordinal()), 1));
                }
                continue;
            }
            map.put(i, ItemStack.f_41583_);
        }
        return map;
    }

    @Override
    public boolean shouldUpdate(EnumInfoRotorUpgradeModules type, ItemStack stack1) {
        List<RotorUpgradeItemInform> list = this.getInformation(stack1);
        for (RotorUpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.max) continue;
            return false;
        }
        return true;
    }
}

