/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.storage.cell;

import com.denfop.IUCore;
import com.denfop.api.storage.StorageStack;
import com.denfop.api.storage.cell.CellInfo;
import com.denfop.api.storage.cell.ICell;
import com.denfop.api.storage.cell.TypeCell;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuAgriculturalAnalyzer;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemStackInventory;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class ItemStackCell
extends ItemStackInventory
implements ICell {
    public final int inventorySize;
    public final ItemStack itemStack1;
    private final CellInfo cellInfo;
    private final int maxCapacity;
    private final boolean isFluid;
    private int storage;
    boolean save = false;
    protected final FluidStack[] inventory_fluid;
    public Map<String, List<StorageStack>> storageMap = new HashMap<String, List<StorageStack>>();

    public ItemStackCell(ItemStack stack, CellInfo cellInfo) {
        super(null, stack, cellInfo.typeCell() == TypeCell.FLUID ? 10 : 100);
        this.inventorySize = cellInfo.typeCell() == TypeCell.FLUID ? 10 : 100;
        this.inventory_fluid = new FluidStack[this.inventorySize];
        Arrays.fill(this.inventory_fluid, FluidStack.EMPTY);
        this.itemStack1 = stack;
        this.cellInfo = cellInfo;
        this.maxCapacity = cellInfo.capacity();
        this.isFluid = cellInfo.typeCell() == TypeCell.FLUID;
        CompoundTag nbt = ModUtils.nbt(this.containerStack);
        if (!nbt.m_128425_("uid", 3)) {
            nbt.m_128405_("uid", IUCore.random.nextInt());
        }
        if (this.isFluid) {
            ListTag contentList = nbt.m_128437_("Fluids", 10);
            for (int i = 0; i < contentList.size(); ++i) {
                CompoundTag slotNbt = contentList.m_128728_(i);
                byte slot = slotNbt.m_128445_("Slot");
                if (slot < 0 || slot >= this.inventory_fluid.length) continue;
                this.inventory_fluid[slot] = FluidStack.loadFluidStackFromNBT((CompoundTag)slotNbt);
                this.storage += this.inventory_fluid[slot].getAmount();
                ResourceLocation rl = BuiltInRegistries.f_257020_.m_7981_((Object)this.inventory_fluid[slot].getFluid());
                List<StorageStack> list = this.storageMap.get(rl.toString());
                if (list == null) {
                    list = new ArrayList<StorageStack>();
                    list.add(new StorageStack(this.inventory_fluid[slot].getTag(), this.inventory_fluid[slot].getAmount(), slot));
                    this.storageMap.put(rl.toString(), list);
                    continue;
                }
                boolean merged = false;
                for (StorageStack stored : list) {
                    if (!NbtUtils.m_129235_((Tag)stored.getTag(), (Tag)this.inventory_fluid[slot].getTag(), (boolean)true)) continue;
                    stored.addCount(this.inventory_fluid[slot].getAmount());
                    merged = true;
                    break;
                }
                if (merged) continue;
                list.add(new StorageStack(this.inventory_fluid[slot].getTag(), this.inventory_fluid[slot].getAmount(), slot));
                this.storageMap.replace(rl.toString(), list);
            }
        } else {
            ListTag contentList = nbt.m_128437_("Items", 10);
            for (int i = 0; i < contentList.size(); ++i) {
                CompoundTag slotNbt = contentList.m_128728_(i);
                byte slot = slotNbt.m_128445_("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.m_41712_((CompoundTag)slotNbt);
                this.inventory[slot].m_41764_(slotNbt.m_128451_("full_count"));
                this.storage += this.inventory[slot].m_41613_();
                ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)this.inventory[slot].m_41720_());
                List<StorageStack> list = this.storageMap.get(rl.toString());
                if (list == null) {
                    list = new ArrayList<StorageStack>();
                    list.add(new StorageStack(this.inventory[slot].m_41783_(), this.inventory[slot].m_41613_(), slot));
                    this.storageMap.put(rl.toString(), list);
                    continue;
                }
                boolean merged = false;
                for (StorageStack stored : list) {
                    if (!NbtUtils.m_129235_((Tag)stored.getTag(), (Tag)this.inventory[slot].m_41783_(), (boolean)true)) continue;
                    stored.addCount(this.inventory[slot].m_41613_());
                    merged = true;
                    break;
                }
                if (merged) continue;
                list.add(new StorageStack(this.inventory[slot].m_41783_(), this.inventory[slot].m_41613_(), slot));
                this.storageMap.replace(rl.toString(), list);
            }
        }
    }

    @Override
    public Map<String, List<StorageStack>> getStorageStack() {
        return this.storageMap;
    }

    @Override
    public ItemStack[] getStacks() {
        return this.inventory;
    }

    @Override
    public FluidStack[] getFluids() {
        return this.inventory_fluid;
    }

    @Override
    public FluidStack addFluid(FluidStack stack) {
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        ResourceLocation rl = BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid());
        List<StorageStack> list = this.storageMap.get(rl.toString());
        int requestedMb = stack.getAmount();
        int freeMb = this.maxCapacity - this.storage;
        if (freeMb <= 0) {
            return stack.copy();
        }
        int toInsert = Math.min(requestedMb, freeMb);
        if (list == null) {
            list = new ArrayList<StorageStack>();
            int slotId = this.addFluidDirect(new FluidStack(stack.getFluid(), toInsert), false);
            list.add(new StorageStack(stack.getTag(), toInsert, slotId));
            this.storageMap.put(rl.toString(), list);
        } else {
            for (StorageStack stored : list) {
                if (!NbtUtils.m_129235_((Tag)stored.getTag(), (Tag)stack.getTag(), (boolean)true)) continue;
                stored.addCount(toInsert);
                this.addFluidDirect(stored.getSlot(), toInsert);
                break;
            }
        }
        this.storage += toInsert;
        return new FluidStack(stack.getFluid(), requestedMb - toInsert);
    }

    @Override
    public FluidStack removeFluid(FluidStack request) {
        if (request.isEmpty()) {
            return FluidStack.EMPTY;
        }
        ResourceLocation rl = BuiltInRegistries.f_257020_.m_7981_((Object)request.getFluid());
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list == null || list.isEmpty()) {
            return FluidStack.EMPTY;
        }
        Iterator<StorageStack> it = list.iterator();
        while (it.hasNext()) {
            StorageStack stored = it.next();
            if (!NbtUtils.m_129235_((Tag)stored.getTag(), (Tag)request.getTag(), (boolean)true)) continue;
            int available = stored.getCount();
            int toExtract = Math.min(available, request.getAmount());
            if (toExtract <= 0) {
                return FluidStack.EMPTY;
            }
            stored.addCount(-toExtract);
            this.storage -= toExtract;
            if (stored.getCount() <= 0) {
                it.remove();
            }
            if (list.isEmpty()) {
                this.storageMap.remove(rl.toString());
            } else {
                this.storageMap.put(rl.toString(), list);
            }
            FluidStack result = new FluidStack(request.getFluid(), toExtract);
            result.setTag(request.getTag());
            this.removeFluid(stored.getSlot(), toExtract);
            return result;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int removeFluid(Fluid item, CompoundTag tag, int remaining) {
        if (item == Fluids.EMPTY) {
            return 0;
        }
        ResourceLocation rl = BuiltInRegistries.f_257020_.m_7981_((Object)item);
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list == null || list.isEmpty()) {
            return 0;
        }
        Iterator<StorageStack> it = list.iterator();
        while (it.hasNext()) {
            StorageStack stored = it.next();
            if (!NbtUtils.m_129235_((Tag)stored.getTag(), (Tag)tag, (boolean)true)) continue;
            int available = stored.getCount();
            int toExtract = Math.min(available, remaining);
            if (toExtract <= 0) {
                return 0;
            }
            stored.addCount(-toExtract);
            this.storage -= toExtract;
            if (stored.getCount() <= 0) {
                it.remove();
            }
            if (list.isEmpty()) {
                this.storageMap.remove(rl.toString());
            } else {
                this.storageMap.put(rl.toString(), list);
            }
            this.removeFluid(stored.getSlot(), toExtract);
            return toExtract;
        }
        return 0;
    }

    private FluidStack removeFluid(int index, int amount) {
        if (index >= 0 && index < this.inventory_fluid.length && !this.inventory_fluid[index].isEmpty()) {
            FluidStack ret;
            FluidStack stack = this.inventory_fluid[index];
            if (amount >= stack.getAmount()) {
                ret = stack;
                this.inventory[index] = ModUtils.emptyStack;
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.inventory_fluid[index] = ModUtils.decSize(stack, amount);
            }
            return ret;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public int canAddFluid(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            return 0;
        }
        int requestMb = stack.getAmount();
        int freeMb = this.maxCapacity - this.storage;
        if (freeMb <= 0) {
            return 0;
        }
        return Math.min(requestMb, freeMb);
    }

    @Override
    public int addFluidDirect(FluidStack stack, boolean simulate) {
        FluidStack current;
        int i;
        if (stack.isEmpty()) {
            return -1;
        }
        int slotId = -1;
        int remaining = stack.getAmount();
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            int space;
            current = this.getFluid(i);
            if (current.isEmpty() || current.getFluid() != stack.getFluid() || (current.getTag() != null || stack.getTag() != null) && !ModUtils.checkNbtEquality(stack.getTag(), current.getTag()) || (space = this.getInventoryStackLimit() - current.getAmount()) <= 0) continue;
            int toMove = Math.min(space, remaining);
            if (!simulate) {
                current.grow(toMove);
            }
            remaining -= toMove;
            slotId = i;
        }
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            current = this.getFluid(i);
            if (!current.isEmpty()) continue;
            int toMove = Math.min(this.getInventoryStackLimit(), remaining);
            if (!simulate) {
                FluidStack newStack = stack.copy();
                newStack.setAmount(toMove);
                this.setFluid(i, newStack);
                slotId = i;
            }
            remaining -= toMove;
        }
        if (remaining > 0) {
            return -1;
        }
        this.save = true;
        return slotId;
    }

    public int addFluidDirect(Fluid stack, CompoundTag tag, int amount, boolean simulate) {
        FluidStack current;
        int i;
        int slotId = -1;
        int remaining = amount;
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            int space;
            current = this.getFluid(i);
            if (current.isEmpty() || current.getFluid() != stack || (current.getTag() != null || tag != null) && !ModUtils.checkNbtEquality(tag, current.getTag()) || (space = this.getInventoryStackLimit() - current.getAmount()) <= 0) continue;
            int toMove = Math.min(space, remaining);
            if (!simulate) {
                current.grow(toMove);
            }
            remaining -= toMove;
            slotId = i;
        }
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            current = this.getFluid(i);
            if (!current.isEmpty()) continue;
            int toMove = Math.min(this.getInventoryStackLimit(), remaining);
            if (!simulate) {
                FluidStack newStack = new FluidStack(stack, toMove);
                this.setFluid(i, newStack);
                slotId = i;
            }
            remaining -= toMove;
        }
        if (remaining > 0) {
            return -1;
        }
        this.save = true;
        return slotId;
    }

    public void addFluidDirect(int slot, int amount) {
        FluidStack current = this.getFluid(slot);
        current.grow(amount);
        this.save = true;
    }

    private void setFluid(int slot, FluidStack stack) {
        this.inventory_fluid[slot] = stack.isEmpty() ? FluidStack.EMPTY : stack;
        this.save();
    }

    @Override
    public CellInfo getCellInfo() {
        return this.cellInfo;
    }

    public int size() {
        return this.inventorySize;
    }

    @Override
    public int canAdd(ItemStack stack) {
        ItemStack current;
        int i;
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        if (stack.m_41619_()) {
            return 0;
        }
        int request = stack.m_41613_();
        if (this.storage >= this.maxCapacity) {
            return 0;
        }
        int allowedByCapacity = Math.min(request, this.maxCapacity - this.storage);
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list != null) {
            ItemStack current2;
            int i2;
            int canInsert = 0;
            for (StorageStack storageStack : list) {
                if (!NbtUtils.m_129235_((Tag)storageStack.getTag(), (Tag)stack.m_41783_(), (boolean)true)) continue;
                canInsert = this.getInventoryStackLimit() - storageStack.getCount();
                canInsert = Math.min(canInsert, allowedByCapacity);
                return canInsert;
            }
            int remaining = allowedByCapacity;
            for (i2 = 0; i2 < this.size() && remaining > 0; ++i2) {
                int space;
                current2 = this.get(i2);
                if (current2.m_41619_() || current2.m_41720_() != stack.m_41720_() || (current2.m_41783_() != null || stack.m_41783_() != null) && !ModUtils.checkNbtEquality(stack.m_41783_(), current2.m_41783_()) || (space = this.getInventoryStackLimit() - current2.m_41613_()) <= 0) continue;
                int take = Math.min(space, remaining);
                canInsert += take;
                remaining -= take;
            }
            for (i2 = 0; i2 < this.size() && remaining > 0; ++i2) {
                current2 = this.get(i2);
                if (!current2.m_41619_()) continue;
                int take = Math.min(this.getInventoryStackLimit(), remaining);
                canInsert += take;
                remaining -= take;
            }
            return canInsert;
        }
        int canInsert = 0;
        int remaining = allowedByCapacity;
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            int space;
            current = this.get(i);
            if (current.m_41619_() || current.m_41720_() != stack.m_41720_() || (current.m_41783_() != null || stack.m_41783_() != null) && !ModUtils.checkNbtEquality(stack.m_41783_(), current.m_41783_()) || (space = this.getInventoryStackLimit() - current.m_41613_()) <= 0) continue;
            int take = Math.min(space, remaining);
            canInsert += take;
            remaining -= take;
        }
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            current = this.get(i);
            if (!current.m_41619_()) continue;
            int take = Math.min(this.getInventoryStackLimit(), remaining);
            canInsert += take;
            remaining -= take;
        }
        return canInsert;
    }

    @Override
    public int canAdd(FluidStack stack) {
        FluidStack current;
        int i;
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        if (stack.isEmpty()) {
            return 0;
        }
        int request = stack.getAmount();
        if (this.storage >= this.maxCapacity) {
            return 0;
        }
        int allowedByCapacity = Math.min(request, this.maxCapacity - this.storage);
        int canInsert = 0;
        int remaining = allowedByCapacity;
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            int space;
            current = this.getFluid(i);
            if (current.isEmpty() || current.getFluid() != stack.getFluid() || (current.getTag() != null || stack.getTag() != null) && !ModUtils.checkNbtEquality(stack.getTag(), current.getTag()) || (space = this.getInventoryStackLimit() - current.getAmount()) <= 0) continue;
            int take = Math.min(space, remaining);
            canInsert += take;
            remaining -= take;
        }
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            current = this.getFluid(i);
            if (!current.isEmpty()) continue;
            int take = Math.min(this.getInventoryStackLimit(), remaining);
            canInsert += take;
            remaining -= take;
        }
        return canInsert;
    }

    @Override
    public void setUpdate(boolean update) {
        this.save = update;
    }

    @Override
    public List<StorageStack> getStorageStackFromItem(ItemStack stack) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        LinkedList<StorageStack> stacks = new LinkedList<StorageStack>();
        List<StorageStack> storage = this.storageMap.get(rl.toString());
        if (storage != null) {
            for (StorageStack storageStack : storage) {
                if (!ModUtils.checkNbtEquality(stack.m_41783_(), storageStack.getTag())) continue;
                stacks.add(storageStack);
            }
        }
        return stacks;
    }

    @Override
    public List<StorageStack> getStorageStackFromFluid(FluidStack stack) {
        ResourceLocation rl = BuiltInRegistries.f_257020_.m_7981_((Object)stack.getFluid());
        LinkedList<StorageStack> stacks = new LinkedList<StorageStack>();
        List<StorageStack> storage = this.storageMap.get(rl.toString());
        if (storage != null) {
            for (StorageStack storageStack : storage) {
                if (!ModUtils.checkNbtEquality(stack.getTag(), storageStack.getTag())) continue;
                stacks.add(storageStack);
            }
        }
        return stacks;
    }

    @Override
    public boolean needUpdate() {
        return this.save;
    }

    public void add(int count, int slot) {
        ItemStack current = this.get(slot);
        current.m_41769_(count);
        this.save = true;
    }

    @Override
    public int add(ItemStack stack, boolean simulate) {
        ItemStack current;
        int i;
        if (stack.m_41619_()) {
            return -1;
        }
        int slotId = -1;
        int remaining = stack.m_41613_();
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            int space;
            current = this.get(i);
            if (current.m_41619_() || current.m_41720_() != stack.m_41720_() || (current.m_41783_() != null || stack.m_41783_() != null) && !ModUtils.checkNbtEquality(stack.m_41783_(), current.m_41783_()) || (space = this.getInventoryStackLimit() - current.m_41613_()) <= 0) continue;
            int toMove = Math.min(space, remaining);
            if (!simulate) {
                current.m_41769_(toMove);
            }
            remaining -= toMove;
        }
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            current = this.get(i);
            if (!current.m_41619_()) continue;
            int toMove = Math.min(this.getInventoryStackLimit(), remaining);
            if (!simulate) {
                ItemStack newStack = stack.m_41777_();
                newStack.m_41764_(toMove);
                this.m_6836_(i, newStack);
                slotId = i;
            }
            remaining -= toMove;
        }
        if (remaining > 0) {
            return -1;
        }
        this.save = true;
        return slotId;
    }

    public int add(Item item, CompoundTag tag, int count, boolean simulate) {
        ItemStack current;
        int i;
        if (item == Items.f_41852_) {
            return -1;
        }
        int slotId = -1;
        int remaining = count;
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            int space;
            current = this.get(i);
            if (current.m_41619_() || current.m_41720_() != item || (current.m_41783_() != null || tag != null) && !ModUtils.checkNbtEquality(tag, current.m_41783_()) || (space = this.getInventoryStackLimit() - current.m_41613_()) <= 0) continue;
            int toMove = Math.min(space, remaining);
            if (!simulate) {
                current.m_41769_(toMove);
            }
            remaining -= toMove;
        }
        for (i = 0; i < this.size() && remaining > 0; ++i) {
            current = this.get(i);
            if (!current.m_41619_()) continue;
            int toMove = Math.min(this.getInventoryStackLimit(), remaining);
            if (!simulate) {
                ItemStack newStack = new ItemStack((ItemLike)item, count, tag);
                newStack.m_41764_(toMove);
                this.m_6836_(i, newStack);
                slotId = i;
            }
            remaining -= toMove;
        }
        if (remaining > 0) {
            return -1;
        }
        this.save = true;
        return slotId;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public void save() {
        if (!this.cleared) {
            ListTag contentList = new ListTag();
            if (this.isFluid) {
                for (int idx = 0; idx < this.inventory_fluid.length; ++idx) {
                    if (this.inventory_fluid[idx].isEmpty()) continue;
                    CompoundTag nbt = new CompoundTag();
                    this.inventory_fluid[idx].writeToNBT(nbt);
                    nbt.m_128405_("full_amount", this.inventory_fluid[idx].getAmount());
                    nbt.m_128344_("Slot", (byte)idx);
                    contentList.add((Object)nbt);
                }
                ModUtils.nbt(this.containerStack).m_128365_("Fluids", (Tag)contentList);
            } else {
                for (int idx = 0; idx < this.inventory.length; ++idx) {
                    if (ModUtils.isEmpty(this.inventory[idx])) continue;
                    CompoundTag nbt = new CompoundTag();
                    this.inventory[idx].m_41739_(nbt);
                    nbt.m_128405_("full_count", this.inventory[idx].m_41613_());
                    nbt.m_128344_("Slot", (byte)idx);
                    contentList.add((Object)nbt);
                }
                ModUtils.nbt(this.containerStack).m_128365_("Items", (Tag)contentList);
            }
            ModUtils.nbt(this.containerStack).m_128405_("storage", this.storage);
        }
    }

    @Override
    public ItemStack addStack(ItemStack stack) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list == null) {
            list = new ArrayList<StorageStack>();
            if (this.storage + stack.m_41613_() <= this.maxCapacity) {
                this.storage += stack.m_41613_();
                int slotId = this.add(stack, false);
                list.add(new StorageStack(stack.m_41783_(), stack.m_41613_(), slotId));
                this.storageMap.put(rl.toString(), list);
                return ItemStack.f_41583_;
            }
            double temp = Math.min(this.maxCapacity - this.storage, stack.m_41613_());
            int slotId = this.add(stack.m_41620_((int)temp), false);
            list.add(new StorageStack(stack.m_41783_(), (int)temp, slotId));
            this.storageMap.put(rl.toString(), list);
            return stack.m_41620_((int)((double)stack.m_41613_() - temp));
        }
        for (StorageStack stack1 : list) {
            if (!NbtUtils.m_129235_((Tag)stack1.getTag(), (Tag)stack.m_41783_(), (boolean)true)) continue;
            if (this.storage + stack.m_41613_() <= this.maxCapacity) {
                this.storage += stack.m_41613_();
                stack1.addCount(stack.m_41613_());
                this.add(stack.m_41613_(), stack1.getSlot());
                return ItemStack.f_41583_;
            }
            int temp = Math.min(this.maxCapacity - this.storage, stack.m_41613_());
            stack1.addCount(temp);
            this.add(temp, stack1.getSlot());
            return stack.m_41620_(stack.m_41613_() - temp);
        }
        if (this.storage + stack.m_41613_() <= this.maxCapacity) {
            this.storage += stack.m_41613_();
            int slotId = this.add(stack, false);
            list.add(new StorageStack(stack.m_41783_(), stack.m_41613_(), slotId));
            this.storageMap.replace(rl.toString(), list);
            return ItemStack.f_41583_;
        }
        double temp = Math.min(this.maxCapacity - this.storage, stack.m_41613_());
        int slotId = this.add(stack.m_41620_((int)temp), false);
        list.add(new StorageStack(stack.m_41783_(), (int)temp, slotId));
        this.storageMap.replace(rl.toString(), list);
        return stack.m_41620_((int)((double)stack.m_41613_() - temp));
    }

    @Override
    public ItemStack removeStackWithIgnoring(ItemStack request) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)request.m_41720_());
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list == null || list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Iterator<StorageStack> it = list.iterator();
        while (it.hasNext()) {
            StorageStack stored = it.next();
            if (!ModUtils.checkNbtEquality(stored.getTag(), request.m_41783_())) continue;
            int available = stored.getCount();
            int toExtract = Math.min(available, request.m_41613_());
            if (toExtract <= 0) {
                return ItemStack.f_41583_;
            }
            this.storage -= toExtract;
            stored.addCount(-toExtract);
            if (stored.getCount() <= 0) {
                it.remove();
            }
            if (list.isEmpty()) {
                this.storageMap.remove(rl.toString());
            } else {
                this.storageMap.put(rl.toString(), list);
            }
            ItemStack result = new ItemStack((ItemLike)request.m_41720_(), toExtract);
            result.m_41751_(request.m_41783_());
            this.m_7407_(stored.getSlot(), toExtract);
            this.save = true;
            return result;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void addStack(Item item, CompoundTag tag, int amount) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list == null) {
            list = new ArrayList<StorageStack>();
            if (this.storage + amount <= this.maxCapacity) {
                this.storage += amount;
                int slotId = this.add(item, tag, amount, false);
                list.add(new StorageStack(tag, amount, slotId));
                this.storageMap.put(rl.toString(), list);
                return;
            }
            int temp = Math.min(this.maxCapacity - this.storage, amount);
            int slotId = this.add(item, tag, temp, false);
            list.add(new StorageStack(tag, temp, slotId));
            this.storageMap.put(rl.toString(), list);
            return;
        }
        boolean added = false;
        for (StorageStack stack1 : list) {
            if (!NbtUtils.m_129235_((Tag)stack1.getTag(), (Tag)tag, (boolean)true)) continue;
            if (this.storage + amount <= this.maxCapacity) {
                this.storage += amount;
                stack1.addCount(amount);
                this.add(amount, stack1.getSlot());
                added = true;
                continue;
            }
            int temp = Math.min(this.maxCapacity - this.storage, amount);
            stack1.addCount(temp);
            this.add(temp, stack1.getSlot());
            added = true;
        }
        if (!added) {
            if (this.storage + amount <= this.maxCapacity) {
                this.storage += amount;
                int slotId = this.add(item, tag, amount, false);
                list.add(new StorageStack(tag, amount, slotId));
                this.storageMap.replace(rl.toString(), list);
            } else {
                int temp = Math.min(this.maxCapacity - this.storage, amount);
                int slotId = this.add(item, tag, temp, false);
                list.add(new StorageStack(tag, temp, slotId));
                this.storageMap.replace(rl.toString(), list);
                return;
            }
        }
    }

    @Override
    public void addFluid(Fluid fluid, CompoundTag tag, int amount) {
        if (fluid == Fluids.EMPTY) {
            return;
        }
        ResourceLocation rl = BuiltInRegistries.f_257020_.m_7981_((Object)fluid);
        List<StorageStack> list = this.storageMap.get(rl.toString());
        int requestedMb = amount;
        int freeMb = this.maxCapacity - this.storage;
        if (freeMb <= 0) {
            return;
        }
        int toInsert = Math.min(requestedMb, freeMb);
        if (list == null) {
            list = new ArrayList<StorageStack>();
            int slotId = this.addFluidDirect(fluid, tag, toInsert, false);
            list.add(new StorageStack(tag, toInsert, slotId));
            this.storageMap.put(rl.toString(), list);
        } else {
            for (StorageStack stored : list) {
                if (!NbtUtils.m_129235_((Tag)stored.getTag(), (Tag)tag, (boolean)true)) continue;
                stored.addCount(toInsert);
                this.addFluidDirect(stored.getSlot(), toInsert);
                break;
            }
        }
        this.storage += toInsert;
    }

    @Override
    public ItemStack removeStack(ItemStack request) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)request.m_41720_());
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list == null || list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Iterator<StorageStack> it = list.iterator();
        while (it.hasNext()) {
            StorageStack stored = it.next();
            if (!NbtUtils.m_129235_((Tag)stored.getTag(), (Tag)request.m_41783_(), (boolean)true)) continue;
            int available = stored.getCount();
            int toExtract = Math.min(available, request.m_41613_());
            if (toExtract <= 0) {
                return ItemStack.f_41583_;
            }
            this.storage -= toExtract;
            stored.addCount(-toExtract);
            if (stored.getCount() <= 0) {
                it.remove();
            }
            if (list.isEmpty()) {
                this.storageMap.remove(rl.toString());
            } else {
                this.storageMap.put(rl.toString(), list);
            }
            this.m_7407_(stored.getSlot(), toExtract);
            this.save = true;
            return new ItemStack((ItemLike)request.m_41720_(), toExtract, request.m_41783_());
        }
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack m_7407_(int index, int amount) {
        ItemStack stack;
        if (index >= 0 && index < this.inventory.length && !ModUtils.isEmpty(stack = this.inventory[index])) {
            ItemStack ret;
            if (amount >= ModUtils.getSize(stack)) {
                ret = stack;
                this.inventory[index] = ModUtils.emptyStack;
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.inventory[index] = ModUtils.decSize(stack, amount);
            }
            return ret;
        }
        return ModUtils.emptyStack;
    }

    @Override
    public int getStorage() {
        return this.storage;
    }

    @Override
    public int removeStack(Item item, CompoundTag requestTag, int toRemove) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list == null || list.isEmpty()) {
            return 0;
        }
        Iterator<StorageStack> it = list.iterator();
        while (it.hasNext()) {
            StorageStack stored = it.next();
            if (!ModUtils.checkNbtEquality(stored.getTag(), requestTag)) continue;
            int available = stored.getCount();
            int toExtract = Math.min(available, toRemove);
            if (toExtract <= 0) {
                return 0;
            }
            this.storage -= toExtract;
            stored.addCount(-toExtract);
            if (stored.getCount() <= 0) {
                it.remove();
            }
            if (list.isEmpty()) {
                this.storageMap.remove(rl.toString());
            } else {
                this.storageMap.put(rl.toString(), list);
            }
            this.m_7407_(stored.getSlot(), toExtract);
            this.save = true;
            return toExtract;
        }
        return 0;
    }

    @Override
    public ItemStack removeItem(ItemStack request) {
        ResourceLocation rl = BuiltInRegistries.f_257033_.m_7981_((Object)request.m_41720_());
        List<StorageStack> list = this.storageMap.get(rl.toString());
        if (list == null || list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        Iterator<StorageStack> it = list.iterator();
        while (it.hasNext()) {
            StorageStack stored = it.next();
            if (!ModUtils.checkNbtEquality(stored.getTag(), request.m_41783_())) continue;
            int available = stored.getCount();
            int toExtract = Math.min(available, request.m_41613_());
            if (toExtract <= 0) {
                return ItemStack.f_41583_;
            }
            this.storage -= toExtract;
            stored.addCount(-toExtract);
            if (stored.getCount() <= 0) {
                it.remove();
            }
            if (list.isEmpty()) {
                this.storageMap.remove(rl.toString());
            } else {
                this.storageMap.put(rl.toString(), list);
            }
            ItemStack result = new ItemStack((ItemLike)request.m_41720_(), toExtract);
            result.m_41751_(request.m_41783_());
            this.m_7407_(stored.getSlot(), toExtract);
            this.save = true;
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ContainerMenuAgriculturalAnalyzer getGuiContainer(Player player) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player player, ContainerMenuBase<?> isAdmin) {
        return null;
    }

    @Override
    public void addInventorySlot(Inventory var1) {
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    public FluidStack getFluid(int index) {
        return this.inventory_fluid[index];
    }

    @Override
    @Nonnull
    public String getName() {
        return "toolbox";
    }

    @Override
    public int getInventoryStackLimit() {
        return Integer.MAX_VALUE;
    }
}

