/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.storage.autocrafting;

import com.denfop.utils.ModUtils;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SameStack {
    private ItemStack stack = ItemStack.f_41583_;
    private FluidStack fluidStack = FluidStack.EMPTY;

    public SameStack() {
    }

    public SameStack(ItemStack stack) {
        this.stack = stack;
    }

    public SameStack(FluidStack stack) {
        this.fluidStack = stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public void setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SameStack sameStack = (SameStack)o;
        if (sameStack.stack.m_41619_() && this.stack.m_41619_() && !this.fluidStack.isEmpty() && !sameStack.fluidStack.isEmpty()) {
            return this.fluidStack.getFluid() == sameStack.fluidStack.getFluid();
        }
        if (!sameStack.stack.m_41619_() && !this.stack.m_41619_() && this.fluidStack.isEmpty() && sameStack.fluidStack.isEmpty()) {
            return ModUtils.checkItemEquality(this.stack, sameStack.stack) && ModUtils.checkNbtEquality(this.stack.m_41783_(), sameStack.stack.m_41783_());
        }
        return false;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public int hashCode() {
        return Objects.hash(this.stack.m_41720_(), this.fluidStack.getFluid());
    }

    public boolean isCorrect(FluidStack stack) {
        return this.fluidStack.getFluid() == stack.getFluid();
    }

    public boolean isCorrect(ItemStack stack) {
        return ModUtils.checkItemEquality(stack, this.stack) && ModUtils.checkNbtEquality(this.stack.m_41783_(), stack.m_41783_());
    }

    public int getAmount() {
        if (this.stack.m_41619_()) {
            return this.fluidStack.getAmount();
        }
        return this.stack.m_41613_();
    }

    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("count", this.getAmount());
        if (!this.stack.m_41619_()) {
            if (this.stack.m_41613_() > 127) {
                this.stack.m_41764_(127);
            }
            nbt.m_128365_("Item", (Tag)this.stack.m_41739_(new CompoundTag()));
        }
        if (!this.fluidStack.isEmpty()) {
            nbt.m_128365_("Fluid", (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
        }
        return nbt;
    }

    public static SameStack readFromNBT(CompoundTag nbt) {
        SameStack sameStack = new SameStack();
        if (nbt.m_128441_("Item")) {
            sameStack.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Item"));
        }
        if (nbt.m_128441_("Fluid")) {
            sameStack.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("Fluid"));
        }
        int amount = nbt.m_128451_("count");
        if (sameStack.isItem()) {
            sameStack.stack.m_41764_(amount);
        }
        if (sameStack.isFluid()) {
            sameStack.fluidStack.setAmount(amount);
        }
        return sameStack;
    }

    public boolean isFluid() {
        return !this.fluidStack.isEmpty();
    }

    public boolean isItem() {
        return !this.stack.m_41619_();
    }
}

